/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Arguments {
    private Arguments() {
    }

    public static <T> T requireNonNull(T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        return object;
    }

    public static String requireNonBlank(String object, String name) {
        if (object.trim().isEmpty()) {
            throw new IllegalArgumentException(name + " must not be blank.");
        }
        return object;
    }

    public static <T> T[] requireNonEmpty(T[] array, String name) {
        if (array.length == 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        return array;
    }

    public static <T> Collection<T> requireNonEmpty(Collection<T> collection, String name) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        return collection;
    }

    public static long requirePositive(long value, String name) {
        if (value <= 0L) {
            throw new IllegalArgumentException(name + " must not be positive.");
        }
        return value;
    }

    public static double requirePositive(double value, String name) {
        if (value <= 0.0) {
            throw new IllegalArgumentException(name + " must not be positive.");
        }
        return value;
    }

    public static BigDecimal requirePositive(BigDecimal value, String name) {
        if (value.signum() <= 0) {
            throw new IllegalArgumentException(name + " must not be positive.");
        }
        return value;
    }

    public static int requireNonNegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " must not be negative.");
        }
        return value;
    }

    public static <T> Set<T> requireUnique(T[] values, String name) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T value : values) {
            if (set.contains(value)) {
                throw new IllegalArgumentException(name + " must be unique.");
            }
            set.add(value);
        }
        return set;
    }
}

