/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.util.HashMap;
import java.util.Map;

public final class MediaType {
    private final String mimeType;
    private final Map<String, String> parameters;

    public static MediaType valueOf(String value) {
        String[] tokens = value.split("\\s*;\\s*");
        if (tokens.length > 0) {
            String mimeType = tokens[0].trim();
            if (mimeType.isEmpty()) {
                throw MediaType.newInvalidMediaTypeException("value");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (int i = 1; i < tokens.length; ++i) {
                String[] keyValue = tokens[i].split("\\s*=\\s*");
                if (keyValue.length != 2) {
                    throw MediaType.newInvalidMediaTypeException("value");
                }
                parameters.put(keyValue[0], keyValue[1]);
            }
            return new MediaType(mimeType, parameters);
        }
        throw MediaType.newInvalidMediaTypeException("value");
    }

    private static RuntimeException newInvalidMediaTypeException(String name) {
        return new IllegalArgumentException(name + " must be a media type.");
    }

    private MediaType(String mimeType, Map<String, String> parameters) {
        this.mimeType = mimeType;
        this.parameters = parameters;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }
}

