/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base;

import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class ResettableReader
extends FilterReader {
    private final CharArrayWriter writer = new CharArrayWriter();

    public ResettableReader(Reader in) {
        super(in);
    }

    @Override
    public final int read() throws IOException {
        int c = super.read();
        if (c >= 0) {
            this.writer.write(c);
        }
        return c;
    }

    @Override
    public final int read(char[] cbuf, int off, int len) throws IOException {
        int actualLen = super.read(cbuf, off, len);
        if (actualLen > 0) {
            this.writer.write(cbuf, off, actualLen);
        }
        return actualLen;
    }

    @Override
    public final long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final Reader createResettedReader() {
        return new SecondReader(this.in, this.writer.toCharArray());
    }

    private static final class SecondReader
    extends FilterReader {
        private final char[] buffer;
        private int index;

        private SecondReader(Reader in, char[] buffer) {
            super(in);
            this.buffer = buffer;
        }

        @Override
        public int read() throws IOException {
            if (this.index < this.buffer.length) {
                return this.buffer[this.index++];
            }
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.index < this.buffer.length) {
                if (this.index + len <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.index, cbuf, off, len);
                    this.index += len;
                    return len;
                }
                int firstLen = this.buffer.length - this.index;
                System.arraycopy(this.buffer, this.index, cbuf, off, firstLen);
                this.index += firstLen;
                int secondLen = super.read(cbuf, off + firstLen, len - firstLen);
                if (secondLen < 0) {
                    return firstLen;
                }
                return firstLen + secondLen;
            }
            return super.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.index < this.buffer.length) {
                if ((long)this.index + n <= (long)this.buffer.length) {
                    this.index = (int)((long)this.index + n);
                    return n;
                }
                long firstLen = this.buffer.length - this.index;
                this.index = this.buffer.length;
                return firstLen + super.skip(n - firstLen);
            }
            return super.skip(n);
        }
    }
}

