/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.leadpony.justify.internal.base.json.DefaultJsonReader;

public class DefaultJsonReaderFactory
implements JsonReaderFactory {
    private final JsonParserFactory parserFactory;
    private final Map<String, ?> config;

    public DefaultJsonReaderFactory(JsonParserFactory parserFactory) {
        this.parserFactory = parserFactory;
        this.config = parserFactory.getConfigInUse();
    }

    public JsonReader createReader(Reader reader) {
        JsonParser parser = this.parserFactory.createParser(reader);
        return new DefaultJsonReader(parser);
    }

    public JsonReader createReader(InputStream in) {
        JsonParser parser = this.parserFactory.createParser(in);
        return new DefaultJsonReader(parser);
    }

    public JsonReader createReader(InputStream in, Charset charset) {
        JsonParser parser = this.parserFactory.createParser(in, charset);
        return new DefaultJsonReader(parser);
    }

    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

