/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.json;

import jakarta.json.stream.JsonLocation;

public final class SimpleJsonLocation
implements JsonLocation {
    public static final JsonLocation UNKNOWN = new SimpleJsonLocation(-1L, -1L, -1L);
    private final long lineNumber;
    private final long columnNumber;
    private final long streamOffset;

    public SimpleJsonLocation(long lineNumber, long columnNumber, long streamOffset) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.streamOffset = streamOffset;
    }

    public static JsonLocation before(JsonLocation other) {
        long lineNumber = other.getLineNumber();
        long columnNumber = other.getColumnNumber();
        long streamOffset = other.getStreamOffset();
        if (columnNumber > 1L) {
            --columnNumber;
        }
        if (streamOffset > 0L) {
            --streamOffset;
        }
        return new SimpleJsonLocation(lineNumber, columnNumber, streamOffset);
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(line no=").append(this.lineNumber).append(", column no=").append(this.columnNumber).append(", offset=").append(this.streamOffset).append(")");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.columnNumber ^ this.columnNumber >>> 32);
        result = 31 * result + (int)(this.lineNumber ^ this.lineNumber >>> 32);
        result = 31 * result + (int)(this.streamOffset ^ this.streamOffset >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof JsonLocation)) {
            return false;
        }
        JsonLocation other = (JsonLocation)obj;
        return this.lineNumber == other.getLineNumber() && this.columnNumber == other.getColumnNumber() && this.streamOffset == other.getStreamOffset();
    }
}

