/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.text;

public final class AsciiCode {
    private static final int RADIX = 10;

    private AsciiCode() {
    }

    public static boolean isAlphabetic(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isAlphanumeric(int c) {
        return AsciiCode.isAlphabetic(c) || AsciiCode.isDigit(c);
    }

    public static boolean isHexDigit(int c) {
        return AsciiCode.isDigit(c) || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public static int hexDigitToValue(int c) {
        if (AsciiCode.isDigit(c)) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return 10 + (c - 97);
        }
        if (c >= 65 && c <= 70) {
            return 10 + (c - 65);
        }
        throw new IllegalArgumentException();
    }
}

