/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.base.text;

import com.ibm.icu.text.IDNA;
import java.util.regex.Pattern;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.base.text.IdnProperty;

public enum Idna {
    IDNA2008{
        private final IDNA idna = IDNA.getUTS46Instance((int)126);

        @Override
        public boolean verifyLabel(String label) {
            if (label.startsWith(Idna.ACE_PREFIX)) {
                return this.verifyALabel(label);
            }
            return this.verifyULabel(label);
        }

        private boolean verifyALabel(String label) {
            StringBuilder builder = new StringBuilder();
            IDNA.Info info = new IDNA.Info();
            this.idna.labelToUnicode((CharSequence)label, builder, info);
            return !info.hasErrors();
        }

        private boolean verifyULabel(String label) {
            boolean asciiOnly = true;
            boolean ldhLabel = true;
            int length = label.length();
            for (int i = 0; i < length; ++i) {
                char c = label.charAt(i);
                if (c < '\u0080') {
                    if (AsciiCode.isAlphanumeric(c) || c == '-') continue;
                    ldhLabel = false;
                    continue;
                }
                asciiOnly = false;
                IdnProperty property = IdnProperty.of(c);
                if (property != IdnProperty.DISALLOWED && property != IdnProperty.UNASSIGNED) continue;
                return false;
            }
            if (asciiOnly) {
                return ldhLabel && Idna.verifyAsciiULabel(label);
            }
            return this.verifyNonAsciiULabel(label);
        }

        private boolean verifyNonAsciiULabel(String label) {
            StringBuilder builder = new StringBuilder();
            IDNA.Info info = new IDNA.Info();
            this.idna.labelToASCII((CharSequence)label, builder, info);
            return !info.hasErrors();
        }
    };

    private static final String ACE_PREFIX = "xn--";
    private static final int MAX_LABEL_LENGTH = 63;
    private static final Pattern DOT_PATTERN;

    public boolean verifyName(CharSequence name) {
        String[] labels;
        for (String label : labels = DOT_PATTERN.split(name, -1)) {
            if (!label.isEmpty() && this.verifyLabel(label)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean verifyLabel(String var1);

    private static boolean verifyAsciiULabel(String label) {
        int length = label.length();
        if (length > 63) {
            return false;
        }
        if (length >= 4 && label.charAt(2) == '-' && label.charAt(3) == '-') {
            return false;
        }
        return !label.startsWith("-") && !label.endsWith("-");
    }

    static {
        DOT_PATTERN = Pattern.compile("\\.");
    }
}

