/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractLogicalEvaluator;
import org.leadpony.justify.internal.evaluator.ChildrenEvaluator;

public abstract class AbstractConjunctivePropertiesEvaluator
extends AbstractLogicalEvaluator
implements ChildrenEvaluator {
    private Evaluator.Result finalResult = Evaluator.Result.TRUE;
    private Evaluator firstChildEvaluator;
    private List<Evaluator> additionalChildEvaluators;

    protected AbstractConjunctivePropertiesEvaluator(EvaluatorContext context) {
        super(context);
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
            return this.finalResult;
        }
        if (depth == 1) {
            this.updateChildren(event, this.getParser());
        }
        if (this.firstChildEvaluator != null) {
            int childDepth = depth - 1;
            if (!this.invokeChildEvaluator(this.firstChildEvaluator, event, childDepth, dispatcher)) {
                this.firstChildEvaluator = null;
            }
            if (this.additionalChildEvaluators != null) {
                Iterator<Evaluator> it = this.additionalChildEvaluators.iterator();
                while (it.hasNext()) {
                    if (this.invokeChildEvaluator(it.next(), event, childDepth, dispatcher)) continue;
                    it.remove();
                }
                if (this.firstChildEvaluator == null && !this.additionalChildEvaluators.isEmpty()) {
                    this.firstChildEvaluator = this.additionalChildEvaluators.remove(0);
                }
            }
        }
        return Evaluator.Result.PENDING;
    }

    @Override
    public void append(Evaluator evaluator) {
        if (evaluator == Evaluator.ALWAYS_TRUE) {
            return;
        }
        if (this.firstChildEvaluator == null) {
            this.firstChildEvaluator = evaluator;
        } else {
            this.getAdditionalChildEvaluators().add(evaluator);
        }
    }

    private boolean invokeChildEvaluator(Evaluator evalutor, JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Evaluator.Result result = evalutor.evaluate(event, depth, dispatcher);
        if (result == Evaluator.Result.PENDING) {
            return true;
        }
        if (result == Evaluator.Result.FALSE) {
            this.finalResult = Evaluator.Result.FALSE;
        }
        return false;
    }

    private List<Evaluator> getAdditionalChildEvaluators() {
        if (this.additionalChildEvaluators == null) {
            this.additionalChildEvaluators = new ArrayList<Evaluator>();
        }
        return this.additionalChildEvaluators;
    }
}

