/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.evaluator;

import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.internal.evaluator.AbstractExclusiveEvaluator;
import org.leadpony.justify.internal.evaluator.DeferredEvaluator;
import org.leadpony.justify.internal.problem.ProblemList;

class ExclusiveEvaluator
extends AbstractExclusiveEvaluator {
    private final List<DeferredEvaluator> operands;
    private final List<DeferredEvaluator> negated;
    private List<ProblemList> problemLists;
    private List<ProblemList> negatedProblemLists;
    private long evaluationsAsTrue;
    private final JsonParser.Event closingEvent;

    ExclusiveEvaluator(EvaluatorContext context, JsonParser.Event closingEvent, Stream<Evaluator> operands, Stream<Evaluator> negated) {
        super(context);
        this.operands = this.createEvaluators(operands);
        this.negated = this.createEvaluators(negated);
        this.closingEvent = closingEvent;
    }

    @Override
    public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        if (this.evaluationsAsTrue <= 1L) {
            this.evaluateAll(event, depth, dispatcher);
        }
        this.evaluateAllNegated(event, depth, dispatcher);
        if (depth == 0 && event == this.closingEvent) {
            if (this.evaluationsAsTrue == 0L) {
                this.dispatchProblems(dispatcher, this.problemLists);
                return Evaluator.Result.FALSE;
            }
            if (this.evaluationsAsTrue > 1L) {
                this.dispatchNegatedProblems(dispatcher, this.negatedProblemLists);
                return Evaluator.Result.FALSE;
            }
            return Evaluator.Result.TRUE;
        }
        return Evaluator.Result.PENDING;
    }

    private void evaluateAll(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Iterator<DeferredEvaluator> it = this.operands.iterator();
        while (it.hasNext()) {
            DeferredEvaluator current = it.next();
            Evaluator.Result result = current.evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.PENDING) continue;
            if (result == Evaluator.Result.TRUE) {
                ++this.evaluationsAsTrue;
            } else if (result == Evaluator.Result.FALSE) {
                this.addBadEvaluator(current);
            }
            it.remove();
        }
    }

    private void evaluateAllNegated(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
        Iterator<DeferredEvaluator> it = this.negated.iterator();
        while (it.hasNext()) {
            DeferredEvaluator current = it.next();
            Evaluator.Result result = current.evaluate(event, depth, dispatcher);
            if (result == Evaluator.Result.PENDING) continue;
            if (result == Evaluator.Result.FALSE) {
                this.addBadNegatedEvaluator(current);
            }
            it.remove();
        }
    }

    private void addBadEvaluator(DeferredEvaluator evaluator) {
        if (this.problemLists == null) {
            this.problemLists = new ArrayList<ProblemList>();
        }
        this.problemLists.add(evaluator.problems());
    }

    private void addBadNegatedEvaluator(DeferredEvaluator evaluator) {
        if (this.negatedProblemLists == null) {
            this.negatedProblemLists = new ArrayList<ProblemList>();
        }
        this.negatedProblemLists.add(evaluator.problems());
    }

    private List<DeferredEvaluator> createEvaluators(Stream<Evaluator> stream) {
        return stream.map(DeferredEvaluator::new).collect(Collectors.toList());
    }
}

