/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.internal.keyword.KeywordFactory;
import org.leadpony.justify.internal.keyword.SchemaKeyword;

public interface KeywordMapper {
    public SchemaKeyword map(JsonValue var1, KeywordFactory.CreationContext var2);

    public static interface FromSchemaMap
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                LinkedHashMap<String, JsonSchema> schemas = new LinkedHashMap<String, JsonSchema>();
                for (Map.Entry entry : value.asJsonObject().entrySet()) {
                    schemas.put((String)entry.getKey(), context.asJsonSchema((JsonValue)entry.getValue()));
                }
                return this.map(value, schemas);
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, Map<String, JsonSchema> var2);
    }

    public static interface FromSchemaList
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.ARRAY) {
                ArrayList<JsonSchema> schemas = new ArrayList<JsonSchema>();
                for (JsonValue item : value.asJsonArray()) {
                    schemas.add(context.asJsonSchema(item));
                }
                return this.map(value, schemas);
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, Collection<JsonSchema> var2);
    }

    public static interface FromSchema
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            return this.map(value, context.asJsonSchema(value));
        }

        public SchemaKeyword map(JsonValue var1, JsonSchema var2);
    }

    public static interface FromUri
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                JsonString string = (JsonString)value;
                URI uri = URI.create(string.getString());
                return this.map((JsonValue)string, uri);
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, URI var2);
    }

    public static interface FromBoolean
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            switch (value.getValueType()) {
                case TRUE: {
                    return this.map(value, true);
                }
                case FALSE: {
                    return this.map(value, false);
                }
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, boolean var2);
    }

    public static interface FromNonNegativeInteger
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                try {
                    int intValue = ((JsonNumber)value).intValueExact();
                    if (intValue >= 0) {
                        return this.map(value, intValue);
                    }
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, int var2);
    }

    public static interface FromNumber
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                JsonNumber number = (JsonNumber)value;
                return this.map((JsonValue)number, number.bigDecimalValue());
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, BigDecimal var2);
    }

    public static interface FromString
    extends KeywordMapper {
        @Override
        default public SchemaKeyword map(JsonValue value, KeywordFactory.CreationContext context) {
            if (value.getValueType() == JsonValue.ValueType.STRING) {
                JsonString string = (JsonString)value;
                return this.map((JsonValue)string, string.getString());
            }
            throw new IllegalArgumentException();
        }

        public SchemaKeyword map(JsonValue var1, String var2);
    }
}

