/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import java.util.Collection;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.evaluator.Evaluators;
import org.leadpony.justify.internal.evaluator.LogicalEvaluator;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.applicator.NaryBooleanLogic;

@KeywordType(value="anyOf")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class AnyOf
extends NaryBooleanLogic {
    public static KeywordMapper mapper() {
        KeywordMapper.FromSchemaList mapper = AnyOf::new;
        return mapper;
    }

    public AnyOf(JsonValue json, Collection<JsonSchema> subschemas) {
        super(json, subschemas);
    }

    @Override
    protected LogicalEvaluator createLogicalEvaluator(EvaluatorContext context, InstanceType type) {
        LogicalEvaluator evaluator = Evaluators.disjunctive(context, type);
        this.getSubschemas().distinct().map(s -> s.createEvaluator(context, type)).forEach(evaluator::append);
        return evaluator;
    }

    @Override
    protected LogicalEvaluator createNegatedLogicalEvaluator(EvaluatorContext context, InstanceType type) {
        LogicalEvaluator evaluator = Evaluators.conjunctive(type);
        this.getSubschemas().distinct().map(s -> s.createNegatedEvaluator(context, type)).forEach(evaluator::append);
        return evaluator;
    }
}

