/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.evaluator.AbstractEvaluator;
import org.leadpony.justify.internal.evaluator.Evaluators;
import org.leadpony.justify.internal.evaluator.LogicalEvaluator;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.ObjectKeyword;
import org.leadpony.justify.internal.keyword.applicator.Applicator;
import org.leadpony.justify.internal.problem.DefaultProblemDispatcher;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="dependencies")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class Dependencies
extends Applicator
implements ObjectKeyword {
    private final Map<String, Dependency> dependencyMap = new HashMap<String, Dependency>();

    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (Map.Entry entry : value.asJsonObject().entrySet()) {
                    String k = (String)entry.getKey();
                    JsonValue v = (JsonValue)entry.getValue();
                    if (v.getValueType() == JsonValue.ValueType.ARRAY) {
                        LinkedHashSet<String> properties = new LinkedHashSet<String>();
                        for (JsonValue item : v.asJsonArray()) {
                            if (item.getValueType() == JsonValue.ValueType.STRING) {
                                properties.add(((JsonString)item).getString());
                                continue;
                            }
                            throw new IllegalArgumentException();
                        }
                        map.put(k, properties);
                        continue;
                    }
                    map.put(k, context.asJsonSchema(v));
                }
                return new Dependencies(value, map);
            }
            throw new IllegalArgumentException();
        };
    }

    public Dependencies(JsonValue json, Map<String, Object> map) {
        super(json);
        map.forEach((property, value) -> {
            if (value instanceof JsonSchema) {
                this.addDependency((String)property, (JsonSchema)value);
            } else if (value instanceof Set) {
                Set requiredProperties = (Set)value;
                this.addDependency((String)property, requiredProperties);
            }
        });
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        LogicalEvaluator evaluator = Evaluators.conjunctive(type);
        this.dependencyMap.values().stream().map(d -> d.createEvaluator(context)).forEach(evaluator::append);
        return evaluator;
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        LogicalEvaluator evaluator = Evaluators.disjunctive(context, type).withProblemBuilderFactory(this);
        this.dependencyMap.values().stream().map(d -> d.createNegatedEvaluator(context)).forEach(evaluator::append);
        return evaluator;
    }

    @Override
    public boolean isInPlace() {
        return true;
    }

    @Override
    public boolean hasSubschemas() {
        return this.dependencyMap.values().stream().anyMatch(Dependency::hasSubschema);
    }

    @Override
    public Stream<JsonSchema> getSubschemas() {
        return this.dependencyMap.values().stream().filter(Dependency::hasSubschema).map(d -> (SchemaDependency)d).map(SchemaDependency::getSubschema);
    }

    public void addDependency(String property, JsonSchema subschema) {
        this.dependencyMap.put(property, this.newDependency(property, subschema));
    }

    public void addDependency(String property, Set<String> requiredProperties) {
        this.dependencyMap.put(property, this.newDependency(property, requiredProperties));
    }

    private Dependency newDependency(String property, JsonSchema subschema) {
        if (subschema == JsonSchema.TRUE || subschema == JsonSchema.EMPTY) {
            return new TrueSchemaDependency(property, subschema);
        }
        if (subschema == JsonSchema.FALSE) {
            return new FalseSchemaDependency(property);
        }
        return new SchemaDependency(property, subschema);
    }

    private Dependency newDependency(String property, Set<String> requiredProperties) {
        if (requiredProperties.isEmpty()) {
            return new EmptyPropertyDependency(property);
        }
        return new PropertyDependency(property, requiredProperties);
    }

    private static abstract class Dependency {
        private final String property;

        protected Dependency(String property) {
            this.property = property;
        }

        String getProperty() {
            return this.property;
        }

        boolean hasSubschema() {
            return false;
        }

        abstract Evaluator createEvaluator(EvaluatorContext var1);

        abstract Evaluator createNegatedEvaluator(EvaluatorContext var1);

        abstract JsonValue getValue(JsonProvider var1);

        abstract void addToJson(JsonObjectBuilder var1, JsonBuilderFactory var2);
    }

    private final class TrueSchemaDependency
    extends SchemaDependency {
        private TrueSchemaDependency(String property, JsonSchema subschema) {
            super(property, subschema);
        }

        @Override
        Evaluator createEvaluator(EvaluatorContext context) {
            return Evaluator.ALWAYS_TRUE;
        }

        @Override
        Evaluator createNegatedEvaluator(EvaluatorContext context) {
            return Evaluators.alwaysFalse(this.getSubschema(), context);
        }
    }

    private final class FalseSchemaDependency
    extends SchemaDependency {
        private FalseSchemaDependency(String property) {
            super(property, JsonSchema.FALSE);
        }

        @Override
        Evaluator createEvaluator(EvaluatorContext context) {
            return new ForbiddenDependantEvaluator(context, this.getProperty());
        }
    }

    private class SchemaDependency
    extends Dependency {
        private final JsonSchema subschema;

        protected SchemaDependency(String property, JsonSchema subschema) {
            super(property);
            this.subschema = subschema;
        }

        @Override
        Evaluator createEvaluator(EvaluatorContext context) {
            Evaluator subschemaEvaluator = this.subschema.createEvaluator(context, InstanceType.OBJECT);
            return new SchemaDependencyEvaluator(context, this.getProperty(), subschemaEvaluator);
        }

        @Override
        Evaluator createNegatedEvaluator(EvaluatorContext context) {
            Evaluator subschemaEvaluator = this.subschema.createNegatedEvaluator(context, InstanceType.OBJECT);
            return new NegatedSchemaDependencyEvaluator(context, this.getProperty(), subschemaEvaluator);
        }

        @Override
        JsonValue getValue(JsonProvider jsonProvider) {
            return this.subschema.toJson();
        }

        @Override
        void addToJson(JsonObjectBuilder builder, JsonBuilderFactory builderFactory) {
            builder.add(this.getProperty(), this.subschema.toJson());
        }

        @Override
        boolean hasSubschema() {
            return true;
        }

        JsonSchema getSubschema() {
            return this.subschema;
        }
    }

    private class EmptyPropertyDependency
    extends PropertyDependency {
        EmptyPropertyDependency(String property) {
            super(property, Collections.emptySet());
        }

        @Override
        Evaluator createEvaluator(EvaluatorContext context) {
            return Evaluator.ALWAYS_TRUE;
        }

        @Override
        Evaluator createNegatedEvaluator(EvaluatorContext context) {
            return new NegatedForbiddenDependantEvaluator(context, this.getProperty());
        }
    }

    private class PropertyDependency
    extends Dependency {
        private final Set<String> requiredProperties;

        PropertyDependency(String property, Set<String> requiredProperties) {
            super(property);
            this.requiredProperties = requiredProperties;
        }

        @Override
        Evaluator createEvaluator(EvaluatorContext context) {
            return new PropertyDependencyEvaluator(context, this.getProperty(), this.requiredProperties);
        }

        @Override
        Evaluator createNegatedEvaluator(EvaluatorContext context) {
            return new NegatedPropertyDependencyEvaluator(context, this.getProperty(), this.requiredProperties);
        }

        @Override
        JsonValue getValue(JsonProvider jsonProvider) {
            JsonArrayBuilder builder = jsonProvider.createArrayBuilder();
            this.requiredProperties.forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
            return builder.build();
        }

        @Override
        void addToJson(JsonObjectBuilder builder, JsonBuilderFactory builderFactory) {
            JsonArrayBuilder valueBuilder = builderFactory.createArrayBuilder();
            this.requiredProperties.forEach(arg_0 -> ((JsonArrayBuilder)valueBuilder).add(arg_0));
            builder.add(this.getProperty(), (JsonValue)valueBuilder.build());
        }
    }

    private class NegatedForbiddenDependantEvaluator
    extends ForbiddenDependantEvaluator {
        NegatedForbiddenDependantEvaluator(EvaluatorContext context, String property) {
            super(context, property);
        }

        @Override
        protected Evaluator.Result getResultWithoutDependant(ProblemDispatcher dispatcher) {
            return this.dispatchMissingDependantProblem(dispatcher);
        }
    }

    private class ForbiddenDependantEvaluator
    extends DependencyEvaluator {
        ForbiddenDependantEvaluator(EvaluatorContext context, String property) {
            super(context, property);
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (depth == 1 && event == JsonParser.Event.KEY_NAME) {
                if (this.getParser().getString().equals(this.property)) {
                    return this.dispatchProblem(dispatcher);
                }
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                return this.getResultWithoutDependant(dispatcher);
            }
            return Evaluator.Result.PENDING;
        }

        private Evaluator.Result dispatchProblem(ProblemDispatcher dispatcher) {
            Problem problem = Dependencies.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_NOT_REQUIRED).withParameter("required", this.property).build();
            dispatcher.dispatchProblem(problem);
            return Evaluator.Result.FALSE;
        }
    }

    private class NegatedPropertyDependencyEvaluator
    extends PropertyDependencyEvaluator {
        NegatedPropertyDependencyEvaluator(EvaluatorContext context, String property, Set<String> required) {
            super(context, property, required);
        }

        @Override
        protected Evaluator.Result getResultWithoutDependant(ProblemDispatcher dispatcher) {
            return this.dispatchMissingDependantProblem(dispatcher);
        }

        @Override
        protected Evaluator.Result test(ProblemDispatcher dispatcher) {
            if (this.required.isEmpty()) {
                Problem p = Dependencies.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_NOT_REQUIRED).withParameter("required", this.property).build();
                dispatcher.dispatchProblem(p);
                return Evaluator.Result.FALSE;
            }
            if (this.missing.isEmpty()) {
                ProblemBuilder b = Dependencies.this.createProblemBuilder(this.getContext()).withParameter("dependant", this.property);
                if (this.required.size() == 1) {
                    b.withMessage(Message.INSTANCE_PROBLEM_NOT_DEPENDENCIES).withParameter("required", this.required.iterator().next());
                } else {
                    b.withMessage(Message.INSTANCE_PROBLEM_NOT_DEPENDENCIES_PLURAL).withParameter("required", this.required);
                }
                dispatcher.dispatchProblem(b.build());
                return Evaluator.Result.FALSE;
            }
            return Evaluator.Result.TRUE;
        }
    }

    private class PropertyDependencyEvaluator
    extends DependencyEvaluator {
        protected final Set<String> required;
        protected final Set<String> missing;

        PropertyDependencyEvaluator(EvaluatorContext context, String property, Set<String> required) {
            super(context, property);
            this.required = required;
            this.missing = new LinkedHashSet<String>(required);
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (depth == 1 && event == JsonParser.Event.KEY_NAME) {
                String keyName = this.getParser().getString();
                if (keyName.equals(this.property)) {
                    this.active = true;
                }
                this.missing.remove(keyName);
            } else if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                if (this.active) {
                    return this.test(dispatcher);
                }
                return this.getResultWithoutDependant(dispatcher);
            }
            return Evaluator.Result.PENDING;
        }

        protected Evaluator.Result test(ProblemDispatcher dispatcher) {
            if (this.missing.isEmpty()) {
                return Evaluator.Result.TRUE;
            }
            for (String entry : this.missing) {
                Problem p = Dependencies.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_DEPENDENCIES).withParameter("required", entry).withParameter("dependant", this.property).build();
                dispatcher.dispatchProblem(p);
            }
            return Evaluator.Result.FALSE;
        }
    }

    private final class NegatedSchemaDependencyEvaluator
    extends SchemaDependencyEvaluator {
        NegatedSchemaDependencyEvaluator(EvaluatorContext context, String property, Evaluator subschemaEvaluator) {
            super(context, property, subschemaEvaluator);
        }

        @Override
        protected Evaluator.Result getResultWithoutDependant(ProblemDispatcher dispatcher) {
            return this.dispatchMissingDependantProblem(dispatcher);
        }
    }

    private class SchemaDependencyEvaluator
    extends DependencyEvaluator
    implements DefaultProblemDispatcher {
        private final Evaluator subschemaEvaluator;
        private Evaluator.Result result;
        private List<Problem> problems;

        SchemaDependencyEvaluator(EvaluatorContext context, String property, Evaluator subschemaEvaluator) {
            super(context, property);
            this.subschemaEvaluator = subschemaEvaluator;
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            String keyName;
            if (!this.active && depth == 1 && event == JsonParser.Event.KEY_NAME && (keyName = this.getParser().getString()).equals(this.property)) {
                this.active = true;
                this.dispatchAllProblems(dispatcher);
            }
            if (this.result == null) {
                this.evaluateSubschema(event, depth, dispatcher);
            }
            if (this.active) {
                return this.result != null ? this.result : Evaluator.Result.PENDING;
            }
            if (depth == 0 && event == JsonParser.Event.END_OBJECT) {
                return this.getResultWithoutDependant(dispatcher);
            }
            return Evaluator.Result.PENDING;
        }

        @Override
        public void dispatchProblem(Problem problem) {
            if (this.problems == null) {
                this.problems = new ArrayList<Problem>();
            }
            this.problems.add(problem);
        }

        private void evaluateSubschema(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            Evaluator.Result result = this.subschemaEvaluator.evaluate(event, depth, this.active ? dispatcher : this);
            if (result != Evaluator.Result.PENDING) {
                this.result = result;
            }
        }

        private void dispatchAllProblems(ProblemDispatcher dispatcher) {
            if (this.problems == null) {
                return;
            }
            for (Problem problem : this.problems) {
                dispatcher.dispatchProblem(problem);
            }
        }
    }

    private abstract class DependencyEvaluator
    extends AbstractEvaluator {
        protected final String property;
        protected boolean active;

        protected DependencyEvaluator(EvaluatorContext context, String property) {
            super(context);
            this.property = property;
            this.active = false;
        }

        protected Evaluator.Result getResultWithoutDependant(ProblemDispatcher dispatcher) {
            return Evaluator.Result.TRUE;
        }

        protected Evaluator.Result dispatchMissingDependantProblem(ProblemDispatcher dispatcher) {
            Problem p = Dependencies.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_REQUIRED).withParameter("required", this.property).build();
            dispatcher.dispatchProblem(p);
            return Evaluator.Result.FALSE;
        }
    }
}

