/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.evaluator.ConditionalEvaluator;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.Conditional;
import org.leadpony.justify.internal.keyword.applicator.UnaryCombiner;

@KeywordType(value="if")
@Spec(value=SpecVersion.DRAFT_07)
public class If
extends Conditional {
    private JsonSchema thenSchema;
    private JsonSchema elseSchema;

    public static KeywordMapper mapper() {
        KeywordMapper.FromSchema mapper = If::new;
        return mapper;
    }

    public If(JsonValue json, JsonSchema schema) {
        super(schema);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        Evaluator ifEvaluator = this.getSubschema().createEvaluator(context, type);
        Evaluator thenEvaluator = this.thenSchema != null ? this.thenSchema.createEvaluator(context, type) : Evaluator.ALWAYS_TRUE;
        Evaluator elseEvaluator = this.elseSchema != null ? this.elseSchema.createEvaluator(context, type) : Evaluator.ALWAYS_TRUE;
        return new ConditionalEvaluator(context, ifEvaluator, thenEvaluator, elseEvaluator);
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        Evaluator ifEvaluator = this.getSubschema().createEvaluator(context, type);
        Evaluator thenEvaluator = this.thenSchema != null ? this.thenSchema.createNegatedEvaluator(context, type) : this.getSubschema().createNegatedEvaluator(context, type);
        Evaluator elseEvaluator = this.elseSchema != null ? this.elseSchema.createNegatedEvaluator(context, type) : this.getSubschema().createEvaluator(context, type);
        return new ConditionalEvaluator(context, ifEvaluator, thenEvaluator, elseEvaluator);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        SchemaKeyword elseKeyword;
        SchemaKeyword thenKeyword;
        if (keywords.containsKey("then") && (thenKeyword = keywords.get("then")) instanceof UnaryCombiner) {
            this.thenSchema = ((UnaryCombiner)thenKeyword).getSubschema();
        }
        if (keywords.containsKey("else") && (elseKeyword = keywords.get("else")) instanceof UnaryCombiner) {
            this.elseSchema = ((UnaryCombiner)elseKeyword).getSubschema();
        }
        if (this.thenSchema != null || this.elseSchema != null) {
            evaluatables.add(this);
        }
    }
}

