/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.json.ParserEvents;
import org.leadpony.justify.internal.evaluator.AbstractConjunctiveItemsEvaluator;
import org.leadpony.justify.internal.evaluator.AbstractDisjunctiveItemsEvaluator;
import org.leadpony.justify.internal.evaluator.EvaluatorDecorator;
import org.leadpony.justify.internal.keyword.ArrayKeyword;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.AdditionalItems;
import org.leadpony.justify.internal.keyword.applicator.Applicator;
import org.leadpony.justify.internal.keyword.applicator.RedundantItemEvaluator;

@KeywordType(value="items")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public abstract class Items
extends Applicator
implements ArrayKeyword {
    public static KeywordMapper mapper() {
        return (value, context) -> {
            switch (value.getValueType()) {
                case ARRAY: {
                    ArrayList<JsonSchema> schemas = new ArrayList<JsonSchema>();
                    for (JsonValue item : value.asJsonArray()) {
                        schemas.add(context.asJsonSchema(item));
                    }
                    return Items.of(value, schemas);
                }
                case OBJECT: 
                case TRUE: 
                case FALSE: {
                    return Items.of(value, context.asJsonSchema(value));
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public static Items of(JsonValue json, JsonSchema subschema) {
        return new BroadcastItems(json, subschema);
    }

    public static Items of(JsonValue json, List<JsonSchema> subschemas) {
        return new DiscreteItems(json, subschemas);
    }

    protected Items(JsonValue json) {
        super(json);
    }

    static class BroadcastItems
    extends Items {
        private final JsonSchema subschema;

        BroadcastItems(JsonValue json, JsonSchema subschema) {
            super(json);
            this.subschema = subschema;
        }

        @Override
        protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
            if (this.subschema == JsonSchema.FALSE) {
                return this.createForbiddenItemsEvaluator(context);
            }
            return this.createItemsEvaluator(context);
        }

        @Override
        protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            if (this.subschema == JsonSchema.TRUE || this.subschema == JsonSchema.EMPTY) {
                return this.createNegatedForbiddenItemsEvaluator(context);
            }
            return this.createNegatedItemsEvaluator(context);
        }

        @Override
        public boolean hasSubschemas() {
            return true;
        }

        @Override
        public Stream<JsonSchema> getSubschemas() {
            return Stream.of(this.subschema);
        }

        @Override
        public JsonSchema getSubschema(Iterator<String> jsonPointer) {
            return this.subschema;
        }

        private Evaluator createItemsEvaluator(EvaluatorContext context) {
            final JsonSchema subschema = this.subschema;
            return new AbstractConjunctiveItemsEvaluator(context){

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        InstanceType type = ParserEvents.toBroadInstanceType(event);
                        this.append(subschema.createEvaluator(this.getContext(), type));
                    }
                }
            };
        }

        private Evaluator createNegatedItemsEvaluator(final EvaluatorContext context) {
            final JsonSchema subschema = this.subschema;
            return new AbstractDisjunctiveItemsEvaluator(context, this){

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        InstanceType type = ParserEvents.toBroadInstanceType(event);
                        this.append(subschema.createNegatedEvaluator(context, type));
                    }
                }
            };
        }

        private Evaluator createForbiddenItemsEvaluator(final EvaluatorContext context) {
            return new AbstractConjunctiveItemsEvaluator(context){
                private int itemIndex;

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        this.append(new RedundantItemEvaluator(context, this.itemIndex++, subschema));
                    }
                }
            };
        }

        private Evaluator createNegatedForbiddenItemsEvaluator(final EvaluatorContext context) {
            return new AbstractDisjunctiveItemsEvaluator(context, this){
                private int itemIndex;

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        this.append(new RedundantItemEvaluator(context, this.itemIndex++, subschema));
                    }
                }
            };
        }
    }

    static class DiscreteItems
    extends Items {
        private final List<JsonSchema> subschemas;
        private JsonSchema defaultSchema = JsonSchema.TRUE;
        private List<JsonValue> defaultValues;

        DiscreteItems(JsonValue json, List<JsonSchema> subschemas) {
            super(json);
            this.subschemas = subschemas;
            this.defaultValues = this.findDefaultValues(subschemas);
        }

        @Override
        protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
            return this.decorateEvaluator(this.createItemsEvaluator(context), context);
        }

        @Override
        protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
            return this.decorateEvaluator(this.createNegatedItemsEvaluator(context), context);
        }

        @Override
        public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
            if (keywords.containsKey("additionalItems")) {
                AdditionalItems additionalItems = (AdditionalItems)keywords.get("additionalItems");
                this.defaultSchema = additionalItems.getSubschema();
            }
            evaluatables.add(this);
        }

        @Override
        public boolean hasSubschemas() {
            return !this.subschemas.isEmpty();
        }

        @Override
        public Stream<JsonSchema> getSubschemas() {
            return this.subschemas.stream();
        }

        @Override
        public JsonSchema getSubschema(Iterator<String> jsonPointer) {
            if (jsonPointer.hasNext()) {
                try {
                    int index = Integer.parseInt(jsonPointer.next());
                    if (index < this.subschemas.size()) {
                        return this.subschemas.get(index);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private JsonSchema findSubschemaAt(int itemIndex) {
            if (itemIndex < this.subschemas.size()) {
                return this.subschemas.get(itemIndex);
            }
            return this.defaultSchema;
        }

        private Evaluator createSubschemaEvaluator(EvaluatorContext context, int itemIndex, JsonSchema subschema, InstanceType type) {
            if (subschema == JsonSchema.FALSE) {
                return new RedundantItemEvaluator(context, itemIndex, subschema);
            }
            return subschema.createEvaluator(context, type);
        }

        private Evaluator createNegatedSubschemaEvaluator(EvaluatorContext context, int itemIndex, JsonSchema subschema, InstanceType type) {
            if (subschema == JsonSchema.TRUE || subschema == JsonSchema.EMPTY) {
                return new RedundantItemEvaluator(context, itemIndex, subschema);
            }
            return subschema.createNegatedEvaluator(context, type);
        }

        private Evaluator createItemsEvaluator(final EvaluatorContext context) {
            return new AbstractConjunctiveItemsEvaluator(context){
                private int itemIndex;

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        InstanceType type = ParserEvents.toBroadInstanceType(event);
                        JsonSchema subschema = this.findSubschemaAt(this.itemIndex);
                        this.append(this.createSubschemaEvaluator(context, this.itemIndex, subschema, type));
                        ++this.itemIndex;
                    }
                }
            };
        }

        private Evaluator createNegatedItemsEvaluator(final EvaluatorContext context) {
            return new AbstractDisjunctiveItemsEvaluator(context, this){
                private int itemIndex;

                @Override
                public void updateChildren(JsonParser.Event event, JsonParser parser) {
                    if (ParserEvents.isValue(event)) {
                        InstanceType type = ParserEvents.toBroadInstanceType(event);
                        JsonSchema subschema = this.findSubschemaAt(this.itemIndex);
                        this.append(this.createNegatedSubschemaEvaluator(context, this.itemIndex, subschema, type));
                        ++this.itemIndex;
                    }
                }
            };
        }

        private List<JsonValue> findDefaultValues(List<JsonSchema> subschemas) {
            for (int i = subschemas.size() - 1; i >= 0; --i) {
                if (!subschemas.get(i).containsKeyword("default")) continue;
                ArrayList<JsonValue> values = new ArrayList<JsonValue>(i + 1);
                for (int j = 0; j <= i; ++j) {
                    values.add(subschemas.get(j).defaultValue());
                }
                return values;
            }
            return null;
        }

        private Evaluator decorateEvaluator(Evaluator evaluator, EvaluatorContext context) {
            if (context.acceptsDefaultValues() && this.defaultValues != null) {
                evaluator = new ItemsDefaultEvaluator(evaluator, context, this.defaultValues);
            }
            return evaluator;
        }
    }

    private static class ItemsDefaultEvaluator
    extends EvaluatorDecorator {
        private final List<JsonValue> defaultValues;
        private int size;

        ItemsDefaultEvaluator(Evaluator evaluator, EvaluatorContext context, List<JsonValue> defaultValues) {
            super(evaluator, context);
            this.defaultValues = defaultValues;
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            Evaluator.Result result = super.evaluate(event, depth, dispatcher);
            if (depth == 1 && ParserEvents.isValue(event)) {
                ++this.size;
            } else if (depth == 0 && event == JsonParser.Event.END_ARRAY) {
                this.supplyDefaultValues(this.size);
                return result;
            }
            return Evaluator.Result.PENDING;
        }

        private void supplyDefaultValues(int size) {
            if (size < this.defaultValues.size()) {
                JsonValue value;
                ArrayList<JsonValue> valuesToPut = new ArrayList<JsonValue>();
                int i = size;
                while (i < this.defaultValues.size() && (value = this.defaultValues.get(i++)) != null) {
                    valuesToPut.add(value);
                }
                if (!valuesToPut.isEmpty()) {
                    this.getContext().putDefaultItems(valuesToPut);
                }
            }
        }
    }
}

