/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.applicator;

import jakarta.json.JsonValue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.applicator.AbstractProperties;

@KeywordType(value="patternProperties")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class PatternProperties
extends AbstractProperties<Pattern> {
    public static KeywordMapper mapper() {
        return (value, context) -> {
            if (value.getValueType() == JsonValue.ValueType.OBJECT) {
                LinkedHashMap<Pattern, JsonSchema> schemas = new LinkedHashMap<Pattern, JsonSchema>();
                try {
                    for (Map.Entry entry : value.asJsonObject().entrySet()) {
                        Pattern pattern = Pattern.compile((String)entry.getKey());
                        schemas.put(pattern, context.asJsonSchema((JsonValue)entry.getValue()));
                    }
                    return new PatternProperties(value, (Map<Pattern, JsonSchema>)schemas);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException();
        };
    }

    public PatternProperties(JsonValue json, Map<Pattern, JsonSchema> properties) {
        super(json, properties);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        super.addToEvaluatables(evaluatables, keywords);
        if (!keywords.containsKey("properties")) {
            evaluatables.add(this);
        }
    }

    @Override
    public JsonSchema getSubschema(Iterator<String> jsonPointer) {
        if (jsonPointer.hasNext()) {
            String token = jsonPointer.next();
            for (Pattern key : this.propertyMap.keySet()) {
                if (!key.pattern().equals(token)) continue;
                return (JsonSchema)this.propertyMap.get(key);
            }
        }
        return null;
    }

    @Override
    protected boolean findSubschemas(String keyName, Consumer<JsonSchema> consumer) {
        boolean found = false;
        for (Pattern pattern : this.propertyMap.keySet()) {
            Matcher m = pattern.matcher(keyName);
            if (!m.find()) continue;
            consumer.accept((JsonSchema)this.propertyMap.get(pattern));
            found = true;
        }
        return found;
    }
}

