/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonValue;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.internal.base.json.JsonInstanceBuilder;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

abstract class AbstractEqualityAssertion
extends AbstractAssertion {
    protected AbstractEqualityAssertion(JsonValue json) {
        super(json);
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        JsonBuilderFactory jsonBuilderFactory = context.getJsonBuilderFactory();
        JsonInstanceBuilder builder = new JsonInstanceBuilder(jsonBuilderFactory);
        return (event, depth, dispatcher) -> {
            if (builder.append(event, context.getParser())) {
                return Evaluator.Result.PENDING;
            }
            JsonValue value = builder.build();
            if (this.testValue(value)) {
                return Evaluator.Result.TRUE;
            }
            ProblemBuilder problemBuilder = this.createProblemBuilder(context).withParameter("actual", value);
            dispatcher.dispatchProblem(this.createProblem(problemBuilder));
            return Evaluator.Result.FALSE;
        };
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        JsonBuilderFactory jsonBuilderFactory = context.getJsonBuilderFactory();
        JsonInstanceBuilder builder = new JsonInstanceBuilder(jsonBuilderFactory);
        return (event, depth, dispatcher) -> {
            if (builder.append(event, context.getParser())) {
                return Evaluator.Result.PENDING;
            }
            JsonValue value = builder.build();
            if (!this.testValue(value)) {
                return Evaluator.Result.TRUE;
            }
            ProblemBuilder problemBuilder = this.createProblemBuilder(context).withParameter("actual", value);
            dispatcher.dispatchProblem(this.createNegatedProblem(problemBuilder));
            return Evaluator.Result.FALSE;
        };
    }

    protected abstract boolean testValue(JsonValue var1);

    protected abstract Problem createProblem(ProblemBuilder var1);

    protected abstract Problem createNegatedProblem(ProblemBuilder var1);
}

