/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.AbstractKeyword;
import org.leadpony.justify.internal.keyword.Evaluatable;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.assertion.Maximum;

@KeywordType(value="maximum")
@Spec(value=SpecVersion.DRAFT_04)
public class Draft04Maximum
extends Maximum {
    private boolean exclusive = false;

    public static KeywordMapper mapper() {
        KeywordMapper.FromNumber mapper = Draft04Maximum::new;
        return mapper;
    }

    public Draft04Maximum(JsonValue json, BigDecimal limit) {
        super(json, limit);
    }

    @Override
    public void addToEvaluatables(List<Evaluatable> evaluatables, Map<String, SchemaKeyword> keywords) {
        if (keywords.containsKey("exclusiveMaximum")) {
            ExclusiveMaximum keyword = (ExclusiveMaximum)keywords.get("exclusiveMaximum");
            this.exclusive = keyword.value;
        }
        super.addToEvaluatables(evaluatables, keywords);
    }

    @Override
    protected boolean testValue(BigDecimal actual, BigDecimal limit) {
        if (this.exclusive) {
            return actual.compareTo(limit) < 0;
        }
        return actual.compareTo(limit) <= 0;
    }

    @Override
    protected Message getMessageForTest() {
        return this.exclusive ? Message.INSTANCE_PROBLEM_EXCLUSIVEMAXIMUM : Message.INSTANCE_PROBLEM_MAXIMUM;
    }

    @Override
    protected Message getMessageForNegatedTest() {
        return this.exclusive ? Message.INSTANCE_PROBLEM_MINIMUM : Message.INSTANCE_PROBLEM_EXCLUSIVEMINIMUM;
    }

    @KeywordType(value="exclusiveMaximum")
    @Spec(value=SpecVersion.DRAFT_04)
    public static class ExclusiveMaximum
    extends AbstractKeyword {
        private final boolean value;

        public static KeywordMapper mapper() {
            KeywordMapper.FromBoolean mapper = ExclusiveMaximum::new;
            return mapper;
        }

        public ExclusiveMaximum(JsonValue json, boolean value) {
            super(json);
            this.value = value;
        }
    }
}

