/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractNumericBoundAssertion;

@KeywordType(value="exclusiveMinimum")
@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class ExclusiveMinimum
extends AbstractNumericBoundAssertion {
    public static KeywordMapper mapper() {
        KeywordMapper.FromNumber mapper = ExclusiveMinimum::new;
        return mapper;
    }

    public ExclusiveMinimum(JsonValue json, BigDecimal limit) {
        super(json, limit);
    }

    @Override
    protected boolean testValue(BigDecimal actual, BigDecimal limit) {
        return actual.compareTo(limit) > 0;
    }

    @Override
    protected Message getMessageForTest() {
        return Message.INSTANCE_PROBLEM_EXCLUSIVEMINIMUM;
    }

    @Override
    protected Message getMessageForNegatedTest() {
        return Message.INSTANCE_PROBLEM_MAXIMUM;
    }
}

