/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonValue;
import java.math.BigDecimal;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractNumericAssertion;
import org.leadpony.justify.internal.problem.ProblemBuilder;

@KeywordType(value="multipleOf")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class MultipleOf
extends AbstractNumericAssertion {
    private final BigDecimal factor;

    public static KeywordMapper mapper() {
        KeywordMapper.FromNumber mapper = MultipleOf::new;
        return mapper;
    }

    public MultipleOf(JsonValue json, BigDecimal factor) {
        super(json);
        this.factor = factor;
    }

    @Override
    protected boolean testValue(BigDecimal value) {
        BigDecimal remainder = value.remainder(this.factor);
        return remainder.compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected Problem createProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_MULTIPLEOF).withParameter("factor", this.factor).build();
    }

    @Override
    protected Problem createNegatedProblem(ProblemBuilder builder) {
        return builder.withMessage(Message.INSTANCE_PROBLEM_NOT_MULTIPLEOF).withParameter("factor", this.factor).build();
    }
}

