/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion;

import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.Evaluator;
import org.leadpony.justify.api.EvaluatorContext;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemDispatcher;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.KeywordType;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.json.JsonInstanceBuilder;
import org.leadpony.justify.internal.evaluator.AbstractEvaluator;
import org.leadpony.justify.internal.keyword.ArrayKeyword;
import org.leadpony.justify.internal.keyword.KeywordMapper;
import org.leadpony.justify.internal.keyword.assertion.AbstractAssertion;

@KeywordType(value="uniqueItems")
@Specs(value={@Spec(value=SpecVersion.DRAFT_04), @Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
public class UniqueItems
extends AbstractAssertion
implements ArrayKeyword {
    private final boolean unique;

    public static KeywordMapper mapper() {
        KeywordMapper.FromBoolean mapper = UniqueItems::new;
        return mapper;
    }

    public UniqueItems(JsonValue json, boolean unique) {
        super(json);
        this.unique = unique;
    }

    @Override
    protected Evaluator doCreateEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.unique) {
            return new AssertionEvaluator(context);
        }
        return Evaluator.ALWAYS_TRUE;
    }

    @Override
    protected Evaluator doCreateNegatedEvaluator(EvaluatorContext context, InstanceType type) {
        if (this.unique) {
            return new NegatedAssertionEvaluator(context);
        }
        return this.createAlwaysFalseEvaluator(context);
    }

    private class AssertionEvaluator
    extends AbstractEvaluator {
        private final JsonBuilderFactory builderFactory;
        private final Map<JsonValue, Integer> values;
        private boolean duplicated;
        private int firstOccurrenceAt;
        private int secondOccurrenceAt;
        private int index;
        private JsonInstanceBuilder builder;

        protected AssertionEvaluator(EvaluatorContext context) {
            super(context);
            this.values = new HashMap<JsonValue, Integer>();
            this.builderFactory = context.getJsonBuilderFactory();
        }

        @Override
        public Evaluator.Result evaluate(JsonParser.Event event, int depth, ProblemDispatcher dispatcher) {
            if (depth == 0) {
                if (event == JsonParser.Event.END_ARRAY) {
                    return this.getFinalResult(dispatcher);
                }
                return Evaluator.Result.PENDING;
            }
            if (this.hasDuplicatedItems()) {
                return Evaluator.Result.PENDING;
            }
            if (this.builder == null) {
                this.builder = new JsonInstanceBuilder(this.builderFactory);
            }
            if (this.builder.append(event, this.getParser())) {
                return Evaluator.Result.PENDING;
            }
            JsonValue value = this.builder.build();
            this.builder = null;
            this.testItemValue(value, this.index++);
            return Evaluator.Result.PENDING;
        }

        private void testItemValue(JsonValue value, int index) {
            if (this.values.containsKey(value)) {
                this.duplicated = true;
                this.firstOccurrenceAt = this.values.get(value);
                this.secondOccurrenceAt = index;
            } else {
                this.values.put(value, index);
            }
        }

        protected final boolean hasDuplicatedItems() {
            return this.duplicated;
        }

        protected Evaluator.Result getFinalResult(ProblemDispatcher dispatcher) {
            if (this.duplicated) {
                Problem p = UniqueItems.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_UNIQUEITEMS).withParameter("index", this.secondOccurrenceAt).withParameter("firstIndex", this.firstOccurrenceAt).build();
                dispatcher.dispatchProblem(p);
                return Evaluator.Result.FALSE;
            }
            return Evaluator.Result.TRUE;
        }
    }

    private final class NegatedAssertionEvaluator
    extends AssertionEvaluator {
        private NegatedAssertionEvaluator(EvaluatorContext context) {
            super(context);
        }

        @Override
        protected Evaluator.Result getFinalResult(ProblemDispatcher dispatcher) {
            if (this.hasDuplicatedItems()) {
                return Evaluator.Result.TRUE;
            }
            Problem p = UniqueItems.this.createProblemBuilder(this.getContext()).withMessage(Message.INSTANCE_PROBLEM_NOT_UNIQUEITEMS).build();
            dispatcher.dispatchProblem(p);
            return Evaluator.Result.FALSE;
        }
    }
}

