/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.keyword.assertion.format.Date;
import org.leadpony.justify.internal.keyword.assertion.format.DateTime;
import org.leadpony.justify.internal.keyword.assertion.format.Email;
import org.leadpony.justify.internal.keyword.assertion.format.Hostname;
import org.leadpony.justify.internal.keyword.assertion.format.IdnEmail;
import org.leadpony.justify.internal.keyword.assertion.format.IdnHostname;
import org.leadpony.justify.internal.keyword.assertion.format.Ipv4;
import org.leadpony.justify.internal.keyword.assertion.format.Ipv6;
import org.leadpony.justify.internal.keyword.assertion.format.Iri;
import org.leadpony.justify.internal.keyword.assertion.format.IriReference;
import org.leadpony.justify.internal.keyword.assertion.format.JsonPointer;
import org.leadpony.justify.internal.keyword.assertion.format.Regex;
import org.leadpony.justify.internal.keyword.assertion.format.RelativeJsonPointer;
import org.leadpony.justify.internal.keyword.assertion.format.Time;
import org.leadpony.justify.internal.keyword.assertion.format.Uri;
import org.leadpony.justify.internal.keyword.assertion.format.UriReference;
import org.leadpony.justify.internal.keyword.assertion.format.UriTemplate;
import org.leadpony.justify.spi.FormatAttribute;

public final class FormatAttributes {
    private static final FormatAttribute[] ATTRIBUTE_LIST = new FormatAttribute[]{new Date(), new DateTime(), new Email(), new Hostname(), new Ipv4(), new Ipv6(), new IdnEmail(), new IdnHostname(), new Iri(), new IriReference(), new JsonPointer(), new Regex(), new RelativeJsonPointer(), new Time(), new Uri(), new UriReference(), new UriTemplate()};
    private static final Map<SpecVersion, Map<String, FormatAttribute>> ATTRIBUTE_BY_SPEC = FormatAttributes.groupAttributesBySpec();

    public static Map<String, FormatAttribute> getAttributes(SpecVersion version) {
        return ATTRIBUTE_BY_SPEC.get((Object)version);
    }

    private static Map<SpecVersion, Map<String, FormatAttribute>> groupAttributesBySpec() {
        HashMap<SpecVersion, Map<String, FormatAttribute>> map = new HashMap<SpecVersion, Map<String, FormatAttribute>>();
        for (SpecVersion specVersion : SpecVersion.values()) {
            map.put(specVersion, new HashMap());
        }
        for (FormatAttribute formatAttribute : ATTRIBUTE_LIST) {
            Spec[] specs;
            for (Spec spec : specs = (Spec[])formatAttribute.getClass().getAnnotationsByType(Spec.class)) {
                ((Map)map.get((Object)spec.value())).put(formatAttribute.name(), formatAttribute);
            }
        }
        return map;
    }

    private FormatAttributes() {
    }
}

