/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatMatcher;

class HostnameMatcher
extends AbstractFormatMatcher {
    static final int MAX_LABEL_CHARS = 63;
    static final int MAX_DOMAIN_CHARS = 253;

    HostnameMatcher(CharSequence input) {
        super(input);
    }

    HostnameMatcher(CharSequence input, int start, int end) {
        super(input, start, end);
    }

    @Override
    public boolean test() {
        int start = this.pos();
        this.subdomain();
        int length = this.pos() - start;
        return length <= 253;
    }

    private void subdomain() {
        this.label();
        while (this.hasNext()) {
            if (this.next() == 46) {
                this.label();
                continue;
            }
            HostnameMatcher.fail();
        }
    }

    private void label() {
        int length;
        int start = this.pos();
        int c = this.next();
        if (!this.checkFirstLabelLetter(c)) {
            HostnameMatcher.fail();
        }
        while (this.hasNext() && this.peek() != 46) {
            c = this.next();
            if (this.checkLabelLetter(c)) continue;
            HostnameMatcher.fail();
        }
        if (c == 45) {
            HostnameMatcher.fail();
        }
        if ((length = this.pos() - start) == 0 || length > 63) {
            HostnameMatcher.fail();
        }
    }

    protected boolean checkFirstLabelLetter(int c) {
        return AsciiCode.isAlphanumeric(c);
    }

    protected boolean checkLabelLetter(int c) {
        return AsciiCode.isAlphanumeric(c) || c == 45;
    }
}

