/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import org.leadpony.justify.api.Localizable;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.annotation.Spec;
import org.leadpony.justify.internal.annotation.Specs;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.keyword.assertion.format.AbstractFormatAttribute;

@Specs(value={@Spec(value=SpecVersion.DRAFT_06), @Spec(value=SpecVersion.DRAFT_07)})
class JsonPointer
extends AbstractFormatAttribute {
    JsonPointer() {
    }

    @Override
    public String name() {
        return "json-pointer";
    }

    @Override
    public Localizable localizedName() {
        return Message.FORMAT_JSON_POINTER;
    }

    @Override
    public boolean test(String value) {
        if (value.isEmpty()) {
            return true;
        }
        char c = value.charAt(0);
        if (c != '/') {
            return false;
        }
        int length = value.length();
        for (int i = 1; i < length; ++i) {
            c = value.charAt(i);
            if (c != '~') continue;
            if (i + 1 >= length) {
                return false;
            }
            if ((c = value.charAt(++i)) == '0' || c == '1') continue;
            return false;
        }
        return true;
    }
}

