/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.keyword.assertion.format;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.internal.base.text.AsciiCode;
import org.leadpony.justify.internal.keyword.assertion.format.RegExpMatcher;

public class UnicodeRegExpMatcher
extends RegExpMatcher {
    private String lastPropertyName;
    private String lastPropertyValue;
    private static final String[] PROPERTY_VALUES_FOR_GENERAL_CATEGORY = new String[]{"Cased_Letter", "LC", "Close_Punctuation", "Pe", "Connector_Punctuation", "Pc", "Control", "Cc", "cntrl", "Currency_Symbol", "Sc", "Dash_Punctuation", "Pd", "Decimal_Number", "Nd", "digit", "Enclosing_Mark", "Me", "Final_Punctuation", "Pf", "Format", "Cf", "Initial_Punctuation", "Pi", "Letter", "L", "Letter_Number", "Nl", "Line_Separator", "Zl", "Lowercase_Letter", "Ll", "Mark", "M", "Combining_Mark", "Math_Symbol", "Sm", "Modifier_Letter", "Lm", "Modifier_Symbol", "Sk", "Nonspacing_Mark", "Mn", "Number", "N", "Open_Punctuation", "Ps", "Other", "C", "Other_Letter", "Lo", "Other_Number", "No", "Other_Punctuation", "Po", "Other_Symbol", "So", "Paragraph_Separator", "Zp", "Private_Use", "Co", "Punctuation", "P", "punct", "Separator", "Z", "Space_Separator", "Zs", "Spacing_Mark", "Mc", "Surrogate", "Cs", "Symbol", "S", "Titlecase_Letter", "Lt", "Unassigned", "Cn", "Uppercase_Letter", "Lu"};
    private static final String[] PROPERTY_VALUES_FOR_SCRIPT = new String[]{"Adlam", "Adlm", "Ahom", "Anatolian_Hieroglyphs", "Hluw", "Arabic", "Arab", "Armenian", "Armn", "Avestan", "Avst", "Balinese", "Bali", "Bamum", "Bamu", "Bassa_Vah", "Bass", "Batak", "Batk", "Bengali", "Beng", "Bhaiksuki", "Bhks", "Bopomofo", "Bopo", "Brahmi", "Brah", "Braille", "Brai", "Buginese", "Bugi", "Buhid", "Buhd", "Canadian_Aboriginal", "Cans", "Carian", "Cari", "Caucasian_Albanian", "Aghb", "Chakma", "Cakm", "Cham", "Cherokee", "Cher", "Common", "Zyyy", "Coptic", "Copt", "Qaac", "Cuneiform", "Xsux", "Cypriot", "Cprt", "Cyrillic", "Cyrl", "Deseret", "Dsrt", "Devanagari", "Deva", "Duployan", "Dupl", "Egyptian_Hieroglyphs", "Egyp", "Elbasan", "Elba", "Ethiopic", "Ethi", "Georgian", "Geor", "Glagolitic", "Glag", "Gothic", "Goth", "Grantha", "Gran", "Greek", "Grek", "Gujarati", "Gujr", "Gurmukhi", "Guru", "Han", "Hani", "Hangul", "Hang", "Hanunoo", "Hano", "Hatran", "Hatr", "Hebrew", "Hebr", "Hiragana", "Hira", "Imperial_Aramaic", "Armi", "Inherited", "Zinh", "Qaai", "Inscriptional_Pahlavi", "Phli", "Inscriptional_Parthian", "Prti", "Javanese", "Java", "Kaithi", "Kthi", "Kannada", "Knda", "Katakana", "Kana", "Kayah_Li", "Kali", "Kharoshthi", "Khar", "Khmer", "Khmr", "Khojki", "Khoj", "Khudawadi", "Sind", "Lao", "Laoo", "Latin", "Latn", "Lepcha", "Lepc", "Limbu", "Limb", "Linear_A", "Lina", "Linear_B", "Linb", "Lisu", "Lycian", "Lyci", "Lydian", "Lydi", "Mahajani", "Mahj", "Malayalam", "Mlym", "Mandaic", "Mand", "Manichaean", "Mani", "Marchen", "Marc", "Masaram_Gondi", "Gonm", "Meetei_Mayek", "Mtei", "Mende_Kikakui", "Mend", "Meroitic_Cursive", "Merc", "Meroitic_Hieroglyphs", "Mero", "Miao", "Plrd", "Modi", "Mongolian", "Mong", "Mro", "Mroo", "Multani", "Mult", "Myanmar", "Mymr", "Nabataean", "Nbat", "New_Tai_Lue", "Talu", "Newa", "Nko", "Nkoo", "Nushu", "Nshu", "Ogham", "Ogam", "Ol_Chiki", "Olck", "Old_Hungarian", "Hung", "Old_Italic", "Ital", "Old_North_Arabian", "Narb", "Old_Permic", "Perm", "Old_Persian", "Xpeo", "Old_South_Arabian", "Sarb", "Old_Turkic", "Orkh", "Oriya", "Orya", "Osage", "Osge", "Osmanya", "Osma", "Pahawh_Hmong", "Hmng", "Palmyrene", "Palm", "Pau_Cin_Hau", "Pauc", "Phags_Pa", "Phag", "Phoenician", "Phnx", "Psalter_Pahlavi", "Phlp", "Rejang", "Rjng", "Runic", "Runr", "Samaritan", "Samr", "Saurashtra", "Saur", "Sharada", "Shrd", "Shavian", "Shaw", "Siddham", "Sidd", "SignWriting", "Sgnw", "Sinhala", "Sinh", "Sora_Sompeng", "Sora", "Soyombo", "Soyo", "Sundanese", "Sund", "Syloti_Nagri", "Sylo", "Syriac", "Syrc", "Tagalog", "Tglg", "Tagbanwa", "Tagb", "Tai_Le", "Tale", "Tai_Tham", "Lana", "Tai_Viet", "Tavt", "Takri", "Takr", "Tamil", "Taml", "Tangut", "Tang", "Telugu", "Telu", "Thaana", "Thaa", "Thai", "Tibetan", "Tibt", "Tifinagh", "Tfng", "Tirhuta", "Tirh", "Ugaritic", "Ugar", "Vai", "Vaii", "Warang_Citi", "Wara", "Yi", "Yiii", "Zanabazar_Square", "Zanb"};
    private static final Map<String, Set<String>> NON_BINARY_PROPERTY_SET = new HashMap<String, Set<String>>(){
        {
            HashSet<String> categoryValues = new HashSet<String>();
            for (String value : PROPERTY_VALUES_FOR_GENERAL_CATEGORY) {
                categoryValues.add(value);
            }
            HashSet<String> scriptValues = new HashSet<String>();
            for (String value : PROPERTY_VALUES_FOR_SCRIPT) {
                scriptValues.add(value);
            }
            this.put("General_Category", categoryValues);
            this.put("gc", categoryValues);
            this.put("Script", scriptValues);
            this.put("sc", scriptValues);
            this.put("Script_Extensions", scriptValues);
            this.put("scx", scriptValues);
        }
    };
    private static final String[] BINARY_PROPERTIES = new String[]{"ASCII", "ASCII_Hex_Digit", "AHex", "Alphabetic", "Alpha", "Any", "Assigned", "Bidi_Control", "Bidi_C", "Bidi_Mirrored", "Bidi_M", "Case_Ignorable", "CI", "Cased", "Changes_When_Casefolded", "CWCF", "Changes_When_Casemapped", "CWCM", "Changes_When_Lowercased", "CWL", "Changes_When_NFKC_Casefolded", "CWKCF", "Changes_When_Titlecased", "CWT", "Changes_When_Uppercased", "CWU", "Dash", "Default_Ignorable_Code_Point", "DI", "Deprecated", "Dep", "Diacritic", "Dia", "Emoji", "Emoji_Component", "Emoji_Modifier", "Emoji_Modifier_Base", "Emoji_Presentation", "Extender", "Ext", "Grapheme_Base", "Gr_Base", "Grapheme_Extend", "Gr_Ext", "Hex_Digit", "Hex", "IDS_Binary_Operator", "IDSB", "IDS_Trinary_Operator", "IDST", "ID_Continue", "IDC", "ID_Start", "IDS", "Ideographic", "Ideo", "Join_Control", "Join_C", "Logical_Order_Exception", "LOE", "Lowercase", "Lower", "Math", "Noncharacter_Code_Point", "NChar", "Pattern_Syntax", "Pat_Syn", "Pattern_White_Space", "Pat_WS", "Quotation_Mark", "QMark", "Radical", "Regional_Indicator", "RI", "Sentence_Terminal", "STerm", "Soft_Dotted", "SD", "Terminal_Punctuation", "Term", "Unified_Ideograph", "UIdeo", "Uppercase", "Upper", "Variation_Selector", "VS", "White_Space", "space", "XID_Continue", "XIDC", "XID_Start", "XIDS"};
    private static final Set<String> BINARY_PROPERTY_SET = new HashSet<String>(){
        {
            for (String property : BINARY_PROPERTIES) {
                this.add(property);
            }
        }
    };
    private static final Set<String> GENERAL_CATEGORY_VALUE_SET = new HashSet<String>(){
        {
            for (String value : PROPERTY_VALUES_FOR_GENERAL_CATEGORY) {
                this.add(value);
            }
        }
    };

    UnicodeRegExpMatcher(CharSequence input) {
        super(input);
    }

    @Override
    protected boolean regExpUnicodeEscapeSequence() {
        if (!this.hasNext(117)) {
            return false;
        }
        int mark = this.pos();
        this.next();
        if (this.hasNext(123)) {
            this.next();
            if (this.codePoint() && this.hasNext(125)) {
                this.next();
                return this.withClassAtomOf(this.lastNumericValue);
            }
        } else if (this.hex4Digits()) {
            int high = this.lastNumericValue;
            if (Character.isHighSurrogate((char)high)) {
                mark = this.pos();
                if (this.isFollowedBy(92, 117) && this.hex4Digits()) {
                    int low = this.lastNumericValue;
                    int codePoint = Character.toCodePoint((char)high, (char)low);
                    return this.withClassAtomOf(codePoint);
                }
                this.backtrack(mark);
            }
            return this.withClassAtomOf(high);
        }
        return this.backtrack(mark);
    }

    @Override
    protected boolean identityEscape() {
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (this.syntaxCharacter()) {
            return this.withClassAtomOf(c);
        }
        if (c == 47) {
            this.next();
            return this.withClassAtomOf(c);
        }
        return false;
    }

    @Override
    protected boolean testCharacterClassEscape() {
        if (super.testCharacterClassEscape()) {
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        int c = this.peek();
        if (c == 112 || c == 80) {
            int mark = this.pos();
            this.next();
            if (this.hasNext(123)) {
                this.next();
                if (this.unicodePropertyValueExpression() && this.hasNext(125)) {
                    this.next();
                    return UnicodeRegExpMatcher.checkProperty(this.lastPropertyName, this.lastPropertyValue);
                }
            }
            this.backtrack(mark);
        }
        return false;
    }

    private boolean unicodePropertyValueExpression() {
        int nameStart = this.pos();
        if (this.unicodePropertyName()) {
            String name = this.extract(nameStart);
            if (this.hasNext(61)) {
                this.next();
                int valueStart = this.pos();
                if (this.unicodePropertyValue()) {
                    String value = this.extract(valueStart);
                    this.lastPropertyName = name;
                    this.lastPropertyValue = value;
                    return true;
                }
            }
            this.backtrack(nameStart);
        }
        return this.loneUnicodePropertyNameOrValue();
    }

    private boolean unicodePropertyName() {
        return this.unicodePropertyNameCharacters();
    }

    private boolean unicodePropertyNameCharacters() {
        if (this.unicodePropertyNameCharacter()) {
            while (this.unicodePropertyNameCharacter()) {
            }
            return true;
        }
        return false;
    }

    private boolean unicodePropertyValue() {
        return this.unicodePropertyValueCharacters();
    }

    private boolean loneUnicodePropertyNameOrValue() {
        int nameStart = this.pos();
        if (this.unicodePropertyValueCharacters()) {
            this.lastPropertyName = this.extract(nameStart);
            this.lastPropertyValue = null;
            return true;
        }
        return false;
    }

    private boolean unicodePropertyValueCharacters() {
        if (this.unicodePropertyValueCharacter()) {
            while (this.unicodePropertyValueCharacter()) {
            }
            return true;
        }
        return false;
    }

    private boolean unicodePropertyValueCharacter() {
        if (this.unicodePropertyNameCharacter()) {
            return true;
        }
        if (this.hasNext() && AsciiCode.isDigit(this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean unicodePropertyNameCharacter() {
        int c;
        if (this.hasNext() && (UnicodeRegExpMatcher.isControlLetter(c = this.peek()) || c == 95)) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean codePoint() {
        if (!this.hasNext()) {
            return false;
        }
        int mark = this.pos();
        int value = AsciiCode.hexDigitToValue(this.next());
        while (this.hasNext()) {
            if (AsciiCode.isHexDigit(this.peek())) {
                value = value * 16 + AsciiCode.hexDigitToValue(this.next());
                continue;
            }
            this.lastNumericValue = value;
            return true;
        }
        return this.backtrack(mark);
    }

    private boolean isFollowedBy(int ... chars) {
        int mark = this.pos();
        for (int c : chars) {
            if (!this.hasNext(c)) {
                return this.backtrack(mark);
            }
            this.next();
        }
        return true;
    }

    private static boolean checkProperty(String name, String value) {
        if (value != null) {
            return UnicodeRegExpMatcher.checkPropertyNameAndValue(name, value);
        }
        return UnicodeRegExpMatcher.checkLoneProperty(name);
    }

    private static boolean checkPropertyNameAndValue(String name, String value) {
        Set<String> values;
        if (NON_BINARY_PROPERTY_SET.containsKey(name) && (values = NON_BINARY_PROPERTY_SET.get(name)).contains(value)) {
            return true;
        }
        return UnicodeRegExpMatcher.earlyError();
    }

    private static boolean checkLoneProperty(String property) {
        if (BINARY_PROPERTY_SET.contains(property) || GENERAL_CATEGORY_VALUE_SET.contains(property)) {
            return true;
        }
        return UnicodeRegExpMatcher.earlyError();
    }
}

