/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.provider;

import jakarta.json.JsonException;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaBuilderFactory;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.JsonSchemaReaderFactory;
import org.leadpony.justify.api.JsonSchemaReaderFactoryBuilder;
import org.leadpony.justify.api.JsonValidationService;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.api.ProblemHandlerFactory;
import org.leadpony.justify.api.ProblemPrinterBuilder;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.api.ValidationConfig;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.json.DefaultJsonReader;
import org.leadpony.justify.internal.base.json.DefaultJsonReaderFactory;
import org.leadpony.justify.internal.base.json.JsonProviderDecorator;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.problem.DefaultProblemPrinterBuilder;
import org.leadpony.justify.internal.provider.DefaultSchemaSpecRegistry;
import org.leadpony.justify.internal.schema.DefaultJsonSchemaBuilderFactory;
import org.leadpony.justify.internal.schema.SchemaSpecRegistry;
import org.leadpony.justify.internal.schema.io.JsonSchemaReaderFactoryImpl;
import org.leadpony.justify.internal.validator.DefaultValidationConfig;
import org.leadpony.justify.internal.validator.JsonValidator;
import org.leadpony.justify.internal.validator.JsonValidatorFactory;

class DefaultJsonValidationService
extends JsonService
implements JsonValidationService {
    private final JsonSchemaReaderFactory defaultSchemaReaderFactory;
    private final SchemaSpecRegistry specRegistry = DefaultSchemaSpecRegistry.load(this);

    DefaultJsonValidationService(JsonProvider jsonProvider) {
        super(jsonProvider);
        this.defaultSchemaReaderFactory = this.createSchemaReaderFactoryBuilder().build();
    }

    @Override
    public JsonSchemaReaderFactory createSchemaReaderFactory() {
        return this.defaultSchemaReaderFactory;
    }

    @Override
    public JsonSchemaReaderFactoryBuilder createSchemaReaderFactoryBuilder() {
        return JsonSchemaReaderFactoryImpl.builder(this, this.specRegistry);
    }

    @Override
    public JsonSchemaReader createSchemaReader(InputStream in) {
        return this.createSchemaReaderFactory().createSchemaReader(in);
    }

    @Override
    public JsonSchemaReader createSchemaReader(InputStream in, Charset charset) {
        return this.createSchemaReaderFactory().createSchemaReader(in, charset);
    }

    @Override
    public JsonSchemaReader createSchemaReader(Reader reader) {
        return this.createSchemaReaderFactory().createSchemaReader(reader);
    }

    @Override
    public JsonSchemaReader createSchemaReader(Path path) {
        return this.createSchemaReaderFactory().createSchemaReader(path);
    }

    @Override
    public JsonSchemaReader createSchemaReader(JsonParser parser) {
        return this.createSchemaReaderFactory().createSchemaReader(parser);
    }

    @Override
    public JsonSchemaBuilderFactory createSchemaBuilderFactory() {
        return this.createDefaultSchemaBuilderFactory();
    }

    @Override
    public ValidationConfig createValidationConfig() {
        return new DefaultValidationConfig();
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        if (config.containsKey("org.leadpony.justify.api.ValidationConfig.SCHEMA")) {
            return new JsonValidatorFactory(this.getJsonProvider(), this.getJsonParserFactory(), config);
        }
        return this.getJsonProvider().createParserFactory(config);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config, JsonSchema schema, ProblemHandlerFactory handlerFactory) {
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handlerFactory, "handlerFactory");
        return this.createParserFactory(this.createValidationConfig().withProperties(config).withSchema(schema).withProblemHandlerFactory(handlerFactory).getAsMap());
    }

    @Override
    public JsonParser createParser(InputStream in, JsonSchema schema, ProblemHandler handler) {
        Arguments.requireNonNull(in, "in");
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handler, "handler");
        JsonParser parser = this.getJsonParserFactory().createParser(in);
        return this.createValidator(parser, schema, handler);
    }

    @Override
    public JsonParser createParser(InputStream in, Charset charset, JsonSchema schema, ProblemHandler handler) {
        Arguments.requireNonNull(in, "in");
        Arguments.requireNonNull(charset, "charset");
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handler, "handler");
        JsonParser parser = this.getJsonParserFactory().createParser(in, charset);
        return this.createValidator(parser, schema, handler);
    }

    @Override
    public JsonParser createParser(Reader reader, JsonSchema schema, ProblemHandler handler) {
        Arguments.requireNonNull(reader, "reader");
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handler, "handler");
        JsonParser parser = this.getJsonParserFactory().createParser(reader);
        return this.createValidator(parser, schema, handler);
    }

    @Override
    public JsonParser createParser(Path path, JsonSchema schema, ProblemHandler handler) {
        Arguments.requireNonNull(path, "path");
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handler, "handler");
        try {
            InputStream in = Files.newInputStream(path, new OpenOption[0]);
            return this.createParser(in, schema, handler);
        }
        catch (NoSuchFileException e) {
            throw DefaultJsonValidationService.buildJsonException(e, Message.INSTANCE_PROBLEM_NOT_FOUND, path);
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public JsonParser createParser(JsonParser parser, JsonSchema schema, ProblemHandler handler) {
        Arguments.requireNonNull(parser, "parser");
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handler, "handler");
        return this.createValidator(parser, schema, handler);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        if (config.containsKey("org.leadpony.justify.api.ValidationConfig.SCHEMA")) {
            JsonParserFactory parserFactory = this.createParserFactory(config);
            return new DefaultJsonReaderFactory(parserFactory);
        }
        return this.getJsonProvider().createReaderFactory(config);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config, JsonSchema schema, ProblemHandlerFactory handlerFactory) {
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handlerFactory, "handlerFactory");
        return this.createReaderFactory(this.createValidationConfig().withProperties(config).withSchema(schema).withProblemHandlerFactory(handlerFactory).getAsMap());
    }

    @Override
    public JsonReader createReader(InputStream in, JsonSchema schema, ProblemHandler handler) {
        JsonParser parser = this.createParser(in, schema, handler);
        return this.createReader(parser);
    }

    @Override
    public JsonReader createReader(InputStream in, Charset charset, JsonSchema schema, ProblemHandler handler) {
        JsonParser parser = this.createParser(in, charset, schema, handler);
        return this.createReader(parser);
    }

    @Override
    public JsonReader createReader(Reader reader, JsonSchema schema, ProblemHandler handler) {
        JsonParser parser = this.createParser(reader, schema, handler);
        return this.createReader(parser);
    }

    @Override
    public JsonReader createReader(Path path, JsonSchema schema, ProblemHandler handler) {
        JsonParser parser = this.createParser(path, schema, handler);
        return this.createReader(parser);
    }

    @Override
    public JsonReader createReader(JsonParser parser, JsonSchema schema, ProblemHandler handler) {
        JsonParser validatingParser = this.createParser(parser, schema, handler);
        return this.createReader(validatingParser);
    }

    @Override
    public JsonProvider createJsonProvider(JsonSchema schema, ProblemHandlerFactory handlerFactory) {
        Arguments.requireNonNull(schema, "schema");
        Arguments.requireNonNull(handlerFactory, "handlerFactory");
        return new ValidatingJsonProvider(this.getJsonProvider(), schema, handlerFactory);
    }

    @Override
    public ProblemHandler createProblemPrinter(Consumer<String> lineConsumer) {
        return this.createProblemPrinter(lineConsumer, Locale.getDefault());
    }

    @Override
    public ProblemHandler createProblemPrinter(Consumer<String> lineConsumer, Locale locale) {
        Arguments.requireNonNull(lineConsumer, "lineConsumer");
        Arguments.requireNonNull(locale, "locale");
        return this.createProblemPrinterBuilder(lineConsumer).withLocale(locale).build();
    }

    @Override
    public ProblemPrinterBuilder createProblemPrinterBuilder(Consumer<String> lineConsumer) {
        Arguments.requireNonNull(lineConsumer, "lineConsumer");
        return new DefaultProblemPrinterBuilder(lineConsumer);
    }

    private DefaultJsonSchemaBuilderFactory createDefaultSchemaBuilderFactory() {
        return new DefaultJsonSchemaBuilderFactory(this, this.specRegistry.getSpec(SpecVersion.DRAFT_07, true));
    }

    private static JsonException buildJsonException(NoSuchFileException e, Message message, Path path) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("path", path);
        String formatted = message.format(arguments);
        return new JsonException(formatted, (Throwable)e);
    }

    private JsonParser createValidator(JsonParser parser, JsonSchema schema, ProblemHandler handler) {
        return new JsonValidator(parser, schema, this.getJsonProvider()).withHandler(handler);
    }

    private JsonReader createReader(JsonParser parser) {
        return new DefaultJsonReader(parser);
    }

    private final class ValidatingJsonProvider
    extends JsonProviderDecorator {
        private final JsonSchema schema;
        private final ProblemHandlerFactory handlerFactory;

        private ValidatingJsonProvider(JsonProvider realProvier, JsonSchema schema, ProblemHandlerFactory handlerFactory) {
            super(realProvier);
            this.schema = schema;
            this.handlerFactory = handlerFactory;
        }

        @Override
        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return DefaultJsonValidationService.this.createParserFactory(config, this.schema, this.handlerFactory);
        }

        @Override
        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return DefaultJsonValidationService.this.createReaderFactory(config, this.schema, this.handlerFactory);
        }
    }
}

