/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema;

import jakarta.json.JsonValue;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.Keyword;
import org.leadpony.justify.api.ObjectJsonSchema;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.json.JsonPointerTokenizer;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.annotation.Default;
import org.leadpony.justify.internal.keyword.core.Comment;
import org.leadpony.justify.internal.keyword.core.Schema;
import org.leadpony.justify.internal.schema.Resolvable;

abstract class AbstractJsonSchema
extends AbstractMap<String, Keyword>
implements ObjectJsonSchema,
Resolvable {
    private URI id;
    private final JsonValue json;
    private final Map<String, SchemaKeyword> keywordMap;

    protected AbstractJsonSchema(URI id, JsonValue json, Map<String, SchemaKeyword> keywords) {
        this.id = id;
        this.json = json;
        this.keywordMap = Collections.unmodifiableMap(keywords);
        this.keywordMap.forEach((k, v) -> v.setEnclosingSchema(this));
        if (this.hasAbsoluteId()) {
            this.resolveSubschemas(this.id());
        }
    }

    @Override
    public boolean hasId() {
        return this.id != null;
    }

    @Override
    public URI id() {
        return this.id;
    }

    @Override
    public URI schema() {
        if (this.containsKeyword("$schema")) {
            Schema keyword = (Schema)this.getKeyword("$schema");
            return (URI)keyword.value();
        }
        return null;
    }

    @Override
    public String comment() {
        if (this.containsKeyword("$comment")) {
            Comment keyword = (Comment)this.getKeyword("$comment");
            return (String)keyword.value();
        }
        return null;
    }

    @Override
    public JsonValue defaultValue() {
        if (this.containsKeyword("default")) {
            Default keyword = (Default)this.getKeyword("default");
            return keyword.value();
        }
        return null;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean containsKeyword(String keyword) {
        Arguments.requireNonNull(keyword, "keyword");
        return this.keywordMap.containsKey(keyword);
    }

    @Override
    public JsonValue getKeywordValue(String keyword) {
        return this.getKeywordValue(keyword, null);
    }

    @Override
    public JsonValue getKeywordValue(String keyword, JsonValue defaultValue) {
        Arguments.requireNonNull(keyword, "keyword");
        Keyword found = this.keywordMap.get(keyword);
        if (found == null) {
            return defaultValue;
        }
        return found.getValueAsJson();
    }

    @Override
    public Stream<JsonSchema> getSubschemas() {
        return this.keywordMap.values().stream().filter(SchemaKeyword::hasSubschemas).flatMap(SchemaKeyword::getSubschemas);
    }

    @Override
    public Stream<JsonSchema> getInPlaceSubschemas() {
        return this.keywordMap.values().stream().filter(SchemaKeyword::hasSubschemas).filter(SchemaKeyword::isInPlace).flatMap(SchemaKeyword::getSubschemas);
    }

    @Override
    public JsonSchema getSubschemaAt(String jsonPointer) {
        Arguments.requireNonNull(jsonPointer, "jsonPointer");
        if (jsonPointer.isEmpty()) {
            return this;
        }
        return this.searchKeywordsForSubschema(jsonPointer);
    }

    @Override
    public final JsonValue toJson() {
        return this.json;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public void resolve(URI baseUri) {
        if (this.hasAbsoluteId()) {
            return;
        }
        if (this.hasId()) {
            baseUri = this.id = baseUri.resolve(this.id);
        }
        this.resolveSubschemas(baseUri);
    }

    @Override
    public boolean hasAbsoluteId() {
        return this.hasId() && this.id().isAbsolute();
    }

    @Override
    public int size() {
        return this.keywordMap.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keywordMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.keywordMap.containsValue(value);
    }

    @Override
    public Keyword get(Object key) {
        return this.keywordMap.get(key);
    }

    @Override
    public Set<Map.Entry<String, Keyword>> entrySet() {
        Set<Map.Entry<String, Keyword>> entrySet = this.keywordMap.entrySet();
        return entrySet;
    }

    protected <T extends Keyword> T getKeyword(String name) {
        return (T)this.keywordMap.get(name);
    }

    private JsonSchema searchKeywordsForSubschema(String jsonPointer) {
        JsonSchema candidate;
        JsonPointerTokenizer tokenizer = new JsonPointerTokenizer(jsonPointer);
        SchemaKeyword keyword = this.keywordMap.get(tokenizer.next());
        if (keyword != null && (candidate = keyword.getSubschema(tokenizer)) != null) {
            if (tokenizer.hasNext()) {
                return candidate.getSubschemaAt(tokenizer.remaining());
            }
            return candidate;
        }
        return null;
    }

    private void resolveSubschemas(URI baseUri) {
        this.getSubschemas().filter(s -> !s.hasAbsoluteId()).filter(s -> s instanceof Resolvable).forEach((? super T s) -> ((Resolvable)((Object)s)).resolve(baseUri));
    }
}

