/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.leadpony.justify.api.InstanceType;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaBuilder;
import org.leadpony.justify.internal.base.Arguments;
import org.leadpony.justify.internal.base.MediaType;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.annotation.Default;
import org.leadpony.justify.internal.keyword.annotation.Description;
import org.leadpony.justify.internal.keyword.annotation.Title;
import org.leadpony.justify.internal.keyword.applicator.AdditionalItems;
import org.leadpony.justify.internal.keyword.applicator.AdditionalProperties;
import org.leadpony.justify.internal.keyword.applicator.AllOf;
import org.leadpony.justify.internal.keyword.applicator.AnyOf;
import org.leadpony.justify.internal.keyword.applicator.Contains;
import org.leadpony.justify.internal.keyword.applicator.Definitions;
import org.leadpony.justify.internal.keyword.applicator.Dependencies;
import org.leadpony.justify.internal.keyword.applicator.Else;
import org.leadpony.justify.internal.keyword.applicator.If;
import org.leadpony.justify.internal.keyword.applicator.Items;
import org.leadpony.justify.internal.keyword.applicator.Not;
import org.leadpony.justify.internal.keyword.applicator.OneOf;
import org.leadpony.justify.internal.keyword.applicator.PatternProperties;
import org.leadpony.justify.internal.keyword.applicator.Properties;
import org.leadpony.justify.internal.keyword.applicator.PropertyNames;
import org.leadpony.justify.internal.keyword.applicator.Then;
import org.leadpony.justify.internal.keyword.assertion.Const;
import org.leadpony.justify.internal.keyword.assertion.Enum;
import org.leadpony.justify.internal.keyword.assertion.ExclusiveMaximum;
import org.leadpony.justify.internal.keyword.assertion.ExclusiveMinimum;
import org.leadpony.justify.internal.keyword.assertion.MaxContains;
import org.leadpony.justify.internal.keyword.assertion.MaxItems;
import org.leadpony.justify.internal.keyword.assertion.MaxLength;
import org.leadpony.justify.internal.keyword.assertion.MaxProperties;
import org.leadpony.justify.internal.keyword.assertion.Maximum;
import org.leadpony.justify.internal.keyword.assertion.MinContains;
import org.leadpony.justify.internal.keyword.assertion.MinItems;
import org.leadpony.justify.internal.keyword.assertion.MinLength;
import org.leadpony.justify.internal.keyword.assertion.MinProperties;
import org.leadpony.justify.internal.keyword.assertion.Minimum;
import org.leadpony.justify.internal.keyword.assertion.MultipleOf;
import org.leadpony.justify.internal.keyword.assertion.Pattern;
import org.leadpony.justify.internal.keyword.assertion.Required;
import org.leadpony.justify.internal.keyword.assertion.Type;
import org.leadpony.justify.internal.keyword.assertion.UniqueItems;
import org.leadpony.justify.internal.keyword.assertion.content.ContentEncoding;
import org.leadpony.justify.internal.keyword.assertion.content.ContentMediaType;
import org.leadpony.justify.internal.keyword.assertion.content.UnknownContentEncoding;
import org.leadpony.justify.internal.keyword.assertion.content.UnknownContentMediaType;
import org.leadpony.justify.internal.keyword.assertion.format.EvaluatableFormat;
import org.leadpony.justify.internal.keyword.assertion.format.Format;
import org.leadpony.justify.internal.keyword.core.Comment;
import org.leadpony.justify.internal.keyword.core.Id;
import org.leadpony.justify.internal.keyword.core.Schema;
import org.leadpony.justify.internal.schema.BasicJsonSchema;
import org.leadpony.justify.internal.schema.SchemaReference;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;
import org.leadpony.justify.spi.FormatAttribute;

class DefaultJsonSchemaBuilder
implements JsonSchemaBuilder {
    private final JsonService jsonService;
    private final JsonProvider jsonProvider;
    private final JsonBuilderFactory jsonFactory;
    private final JsonObjectBuilder objectBuilder;
    private final SchemaSpec spec;
    private final Map<String, SchemaKeyword> keywords = new LinkedHashMap<String, SchemaKeyword>();
    private URI id;
    private final Map<String, KeywordBuilder> builders = new HashMap<String, KeywordBuilder>();

    DefaultJsonSchemaBuilder(JsonService jsonService, SchemaSpec spec) {
        this.jsonService = jsonService;
        this.jsonProvider = jsonService.getJsonProvider();
        this.jsonFactory = jsonService.getJsonBuilderFactory();
        this.objectBuilder = this.jsonFactory.createObjectBuilder();
        this.spec = spec;
    }

    @Override
    public JsonSchema build() {
        this.finishBuilders();
        JsonObject json = this.objectBuilder.build();
        if (this.keywords.isEmpty()) {
            return JsonSchema.EMPTY;
        }
        if (this.keywords.containsKey("$ref")) {
            return new SchemaReference(this.id, json, this.keywords);
        }
        return BasicJsonSchema.of(this.id, json, this.keywords);
    }

    @Override
    public JsonSchemaBuilder withId(URI id) {
        Arguments.requireNonNull(id, "id");
        this.addKeyword(new Id(this.toJson(id), id));
        this.id = id;
        return this;
    }

    @Override
    public JsonSchemaBuilder withSchema(URI schema) {
        Arguments.requireNonNull(schema, "schema");
        this.addKeyword(new Schema(this.toJson(schema), schema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withComment(String comment) {
        Arguments.requireNonNull(comment, "comment");
        this.addKeyword(new Comment(this.toJson(comment), comment));
        return this;
    }

    @Override
    public JsonSchemaBuilder withType(InstanceType ... types) {
        Arguments.requireNonNull(types, "types");
        Arguments.requireNonEmpty(types, "types");
        Set<InstanceType> set = Arguments.requireUnique(types, "types");
        return this.withType(set);
    }

    @Override
    public JsonSchemaBuilder withType(Set<InstanceType> types) {
        Arguments.requireNonNull(types, "types");
        Arguments.requireNonEmpty(types, "types");
        JsonValue json = types.size() == 1 ? this.toJson(types.iterator().next()) : this.toJsonFromTypes(types);
        this.addKeyword(Type.of(json, types));
        return this;
    }

    @Override
    public JsonSchemaBuilder withEnum(JsonValue ... values) {
        Arguments.requireNonNull(values, "values");
        Arguments.requireNonEmpty(values, "values");
        Set<JsonValue> set = Arguments.requireUnique(values, "values");
        return this.withEnum(set);
    }

    @Override
    public JsonSchemaBuilder withEnum(Set<JsonValue> values) {
        Arguments.requireNonNull(values, "values");
        Arguments.requireNonEmpty(values, "values");
        this.addKeyword(new Enum(this.toJson(values), values));
        return this;
    }

    @Override
    public JsonSchemaBuilder withConst(JsonValue value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new Const(value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMultipleOf(long value) {
        Arguments.requirePositive(value, "value");
        return this.withMultipleOf(BigDecimal.valueOf(value));
    }

    @Override
    public JsonSchemaBuilder withMultipleOf(double value) {
        Arguments.requirePositive(value, "value");
        return this.withMultipleOf(BigDecimal.valueOf(value));
    }

    @Override
    public JsonSchemaBuilder withMultipleOf(BigDecimal value) {
        Arguments.requireNonNull(value, "value");
        Arguments.requirePositive(value, "value");
        this.addKeyword(new MultipleOf(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMaximum(BigDecimal value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new Maximum(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withExclusiveMaximum(BigDecimal value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new ExclusiveMaximum(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMinimum(BigDecimal value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new Minimum(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withExclusiveMinimum(BigDecimal value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new ExclusiveMinimum(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMaxLength(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MaxLength(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMinLength(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MinLength(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withPattern(String pattern) {
        Arguments.requireNonNull(pattern, "pattern");
        java.util.regex.Pattern compiled = java.util.regex.Pattern.compile(pattern);
        this.addKeyword(new Pattern(this.toJson(pattern), compiled));
        return this;
    }

    @Override
    public JsonSchemaBuilder withItems(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(Items.of(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withItemsArray(JsonSchema ... subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        return this.withItemsArray(Arrays.asList(subschemas));
    }

    @Override
    public JsonSchemaBuilder withItemsArray(List<JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        this.addKeyword(Items.of(this.toJsonFromSchemas(subschemas), subschemas));
        return this;
    }

    @Override
    public JsonSchemaBuilder withAdditionalItems(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new AdditionalItems(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMaxItems(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MaxItems(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMinItems(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MinItems(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withUniqueItems(boolean unique) {
        this.addKeyword(new UniqueItems(DefaultJsonSchemaBuilder.toJson(unique), unique));
        return this;
    }

    @Override
    public JsonSchemaBuilder withContains(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new Contains(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMaxContains(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MaxContains(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMinContains(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MinContains(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMaxProperties(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MaxProperties(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withMinProperties(int value) {
        Arguments.requireNonNegative(value, "value");
        this.addKeyword(new MinProperties(this.toJson(value), value));
        return this;
    }

    @Override
    public JsonSchemaBuilder withRequired(String ... names) {
        Arguments.requireNonNull(names, "names");
        Set<String> set = Arguments.requireUnique(names, "names");
        return this.withRequired(set);
    }

    @Override
    public JsonSchemaBuilder withRequired(Set<String> names) {
        Arguments.requireNonNull(names, "names");
        this.addKeyword(new Required(this.toJsonFromStrings(names), names));
        return this;
    }

    @Override
    public JsonSchemaBuilder withProperty(String name, JsonSchema subschema) {
        Arguments.requireNonNull(name, "name");
        Arguments.requireNonNull(subschema, "subschema");
        this.getBuilder("properties", PropertiesBuilder::new).append(name, subschema);
        return this;
    }

    @Override
    public JsonSchemaBuilder withProperties(Map<String, JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        this.getBuilder("properties", PropertiesBuilder::new).append(subschemas);
        return this;
    }

    @Override
    public JsonSchemaBuilder withPatternProperty(String pattern, JsonSchema subschema) {
        Arguments.requireNonNull(pattern, "pattern");
        Arguments.requireNonNull(subschema, "subschema");
        java.util.regex.Pattern compiled = java.util.regex.Pattern.compile(pattern);
        this.getBuilder("patternProperties", PatternPropertiesBuilder::new).append(compiled, subschema);
        return this;
    }

    @Override
    public JsonSchemaBuilder withPatternProperties(Map<String, JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        HashMap compiledMap = new HashMap();
        subschemas.forEach((pattern, subschema) -> compiledMap.put(java.util.regex.Pattern.compile(pattern), subschema));
        this.getBuilder("patternProperties", PatternPropertiesBuilder::new).append(compiledMap);
        return this;
    }

    @Override
    public JsonSchemaBuilder withAdditionalProperties(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new AdditionalProperties(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withDependency(String name, JsonSchema subschema) {
        Arguments.requireNonNull(name, "name");
        Arguments.requireNonNull(subschema, "subschema");
        this.getBuilder("dependencies", DependenciesBuilder::new).append(name, (Object)subschema);
        return this;
    }

    @Override
    public JsonSchemaBuilder withDependency(String name, String ... requiredProperties) {
        Arguments.requireNonNull(name, "name");
        Arguments.requireNonNull(requiredProperties, "requiredProperties");
        return this.withDependency(name, Arguments.requireUnique(requiredProperties, "requiredProperties"));
    }

    @Override
    public JsonSchemaBuilder withDependency(String name, Set<String> requiredProperties) {
        Arguments.requireNonNull(name, "name");
        Arguments.requireNonNull(requiredProperties, "requiredProperties");
        this.getBuilder("dependencies", DependenciesBuilder::new).append(name, (Object)requiredProperties);
        return this;
    }

    @Override
    public JsonSchemaBuilder withDependencies(Map<String, ?> values) {
        Arguments.requireNonNull(values, "values");
        if (!DefaultJsonSchemaBuilder.verifyDependenciesValueType(values)) {
            throw new ClassCastException();
        }
        Map<String, ?> map = values;
        this.getBuilder("dependencies", DependenciesBuilder::new).append(map);
        return this;
    }

    @Override
    public JsonSchemaBuilder withPropertyNames(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new PropertyNames(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withIf(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new If(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withThen(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new Then(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withElse(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new Else(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withAllOf(JsonSchema ... subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        return this.withAllOf(Arrays.asList(subschemas));
    }

    @Override
    public JsonSchemaBuilder withAllOf(List<JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        this.addKeyword(new AllOf(this.toJsonFromSchemas(subschemas), subschemas));
        return this;
    }

    @Override
    public JsonSchemaBuilder withAnyOf(JsonSchema ... subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        return this.withAnyOf(Arrays.asList(subschemas));
    }

    @Override
    public JsonSchemaBuilder withAnyOf(List<JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        this.addKeyword(new AnyOf(this.toJsonFromSchemas(subschemas), subschemas));
        return this;
    }

    @Override
    public JsonSchemaBuilder withOneOf(JsonSchema ... subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        return this.withOneOf(Arrays.asList(subschemas));
    }

    @Override
    public JsonSchemaBuilder withOneOf(List<JsonSchema> subschemas) {
        Arguments.requireNonNull(subschemas, "subschemas");
        Arguments.requireNonEmpty(subschemas, "subschemas");
        this.addKeyword(new OneOf(this.toJsonFromSchemas(subschemas), subschemas));
        return this;
    }

    @Override
    public JsonSchemaBuilder withNot(JsonSchema subschema) {
        Arguments.requireNonNull(subschema, "subschema");
        this.addKeyword(new Not(this.toJson(subschema), subschema));
        return this;
    }

    @Override
    public JsonSchemaBuilder withFormat(String attribute) {
        Arguments.requireNonNull(attribute, "attribute");
        FormatAttribute foundAttribute = this.spec.getFormatAttribute(attribute);
        if (foundAttribute == null) {
            throw new IllegalArgumentException("\"" + attribute + "\" is not recognized as a format attribute.");
        }
        EvaluatableFormat format = new EvaluatableFormat(this.toJson(attribute), foundAttribute);
        this.addKeyword(format);
        return this;
    }

    @Override
    public JsonSchemaBuilder withLaxFormat(String attribute) {
        Arguments.requireNonNull(attribute, "attribute");
        Format format = null;
        FormatAttribute foundAttribute = this.spec.getFormatAttribute(attribute);
        format = foundAttribute != null ? new EvaluatableFormat(this.toJson(attribute), foundAttribute) : new Format(this.toJson(attribute), attribute);
        this.addKeyword(format);
        return this;
    }

    @Override
    public JsonSchemaBuilder withContentEncoding(String value) {
        Arguments.requireNonNull(value, "value");
        JsonValue json = this.toJson(value);
        ContentEncodingScheme scheme = this.spec.getEncodingScheme(value);
        if (scheme != null) {
            this.addKeyword(new ContentEncoding(json, scheme));
        } else {
            this.addKeyword(new UnknownContentEncoding(json, value));
        }
        return this;
    }

    @Override
    public JsonSchemaBuilder withContentMediaType(String value) {
        Arguments.requireNonNull(value, "value");
        JsonValue json = this.toJson(value);
        MediaType mediaType = MediaType.valueOf(value);
        String mimeType = mediaType.mimeType();
        ContentMimeType foundMimeType = this.spec.getMimeType(mimeType);
        if (foundMimeType != null) {
            this.addKeyword(new ContentMediaType(json, foundMimeType, mediaType.parameters()));
        } else {
            this.addKeyword(new UnknownContentMediaType(json, value));
        }
        return this;
    }

    @Override
    public JsonSchemaBuilder withDefinition(String name, JsonSchema schema) {
        Arguments.requireNonNull(name, "name");
        Arguments.requireNonNull(schema, "schema");
        this.getBuilder("definitions", DefinitionsBuilder::new).append(name, schema);
        return this;
    }

    @Override
    public JsonSchemaBuilder withDefinitions(Map<String, JsonSchema> schemas) {
        Arguments.requireNonNull(schemas, "schemas");
        this.getBuilder("definitions", DefinitionsBuilder::new).append(schemas);
        return this;
    }

    @Override
    public JsonSchemaBuilder withTitle(String title) {
        Arguments.requireNonNull(title, "title");
        this.addKeyword(new Title(this.toJson(title), title));
        return this;
    }

    @Override
    public JsonSchemaBuilder withDescription(String description) {
        Arguments.requireNonNull(description, "description");
        this.addKeyword(new Description(this.toJson(description), description));
        return this;
    }

    @Override
    public JsonSchemaBuilder withDefault(JsonValue value) {
        Arguments.requireNonNull(value, "value");
        this.addKeyword(new Default(value));
        return this;
    }

    private void addKeyword(SchemaKeyword keyword) {
        this.keywords.put(keyword.name(), keyword);
        this.objectBuilder.add(keyword.name(), keyword.getValueAsJson());
    }

    private <T extends KeywordBuilder> T getBuilder(String name, Function<JsonBuilderFactory, T> function) {
        KeywordBuilder builder = null;
        if (this.builders.containsKey(name)) {
            builder = this.builders.get(name);
        } else {
            builder = (KeywordBuilder)function.apply(this.jsonService.getJsonBuilderFactory());
            this.builders.put(name, builder);
        }
        return (T)builder;
    }

    private void finishBuilders() {
        for (KeywordBuilder builder : this.builders.values()) {
            this.addKeyword(builder.build());
        }
    }

    private static boolean verifyDependenciesValueType(Map<String, ?> values) {
        for (Object value : values.values()) {
            if (value instanceof JsonSchema) continue;
            if (value instanceof Set) {
                for (Object entry : (Set)value) {
                    if (entry instanceof String) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private JsonValue toJson(String value) {
        return this.jsonProvider.createValue(value);
    }

    private JsonValue toJson(int value) {
        return this.jsonProvider.createValue(value);
    }

    private JsonValue toJson(BigDecimal value) {
        return this.jsonProvider.createValue(value);
    }

    private static JsonValue toJson(boolean value) {
        return value ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private JsonValue toJson(URI value) {
        return this.jsonProvider.createValue(value.toString());
    }

    private JsonValue toJson(JsonSchema value) {
        return value.toJson();
    }

    private JsonValue toJson(InstanceType value) {
        return this.jsonProvider.createValue(value.toString().toLowerCase());
    }

    private JsonValue toJson(Collection<JsonValue> values) {
        JsonArrayBuilder builder = this.jsonFactory.createArrayBuilder();
        for (JsonValue value : values) {
            builder.add(value);
        }
        return builder.build();
    }

    private JsonValue toJsonFromStrings(Collection<String> values) {
        JsonArrayBuilder builder = this.jsonFactory.createArrayBuilder();
        for (String value : values) {
            builder.add(value);
        }
        return builder.build();
    }

    private JsonValue toJsonFromSchemas(Collection<JsonSchema> values) {
        JsonArrayBuilder builder = this.jsonFactory.createArrayBuilder();
        for (JsonSchema value : values) {
            builder.add(value.toJson());
        }
        return builder.build();
    }

    private JsonValue toJsonFromTypes(Collection<InstanceType> values) {
        JsonArrayBuilder builder = this.jsonFactory.createArrayBuilder();
        for (InstanceType value : values) {
            builder.add(value.toString().toLowerCase());
        }
        return builder.build();
    }

    static interface KeywordBuilder {
        public SchemaKeyword build();
    }

    static class PropertiesBuilder
    extends AbstractKeywordBuilder<String, JsonSchema> {
        PropertiesBuilder(JsonBuilderFactory factory) {
            super(factory);
        }

        @Override
        void append(String key, JsonSchema value) {
            super.append(key, value);
            this.objectBuilder.add(key, value.toJson());
        }

        @Override
        public SchemaKeyword build() {
            return new Properties((JsonValue)this.toJson(), this.map);
        }
    }

    static class PatternPropertiesBuilder
    extends AbstractKeywordBuilder<java.util.regex.Pattern, JsonSchema> {
        PatternPropertiesBuilder(JsonBuilderFactory factory) {
            super(factory);
        }

        @Override
        void append(java.util.regex.Pattern key, JsonSchema value) {
            super.append(key, value);
            this.objectBuilder.add(key.toString(), value.toJson());
        }

        @Override
        public SchemaKeyword build() {
            return new PatternProperties((JsonValue)this.toJson(), this.map);
        }
    }

    static class DependenciesBuilder
    extends AbstractKeywordBuilder<String, Object> {
        private final JsonBuilderFactory factory;

        DependenciesBuilder(JsonBuilderFactory factory) {
            super(factory);
            this.factory = factory;
        }

        @Override
        void append(String key, Object value) {
            super.append(key, value);
            if (value instanceof JsonSchema) {
                this.objectBuilder.add(key, ((JsonSchema)value).toJson());
            } else if (value instanceof Collection) {
                JsonArrayBuilder arrayBuilder = this.factory.createArrayBuilder();
                Collection collection = (Collection)value;
                for (Object entry : collection) {
                    if (!(entry instanceof String)) continue;
                    arrayBuilder.add((String)entry);
                }
                this.objectBuilder.add(key, arrayBuilder);
            }
        }

        @Override
        public SchemaKeyword build() {
            return new Dependencies((JsonValue)this.toJson(), this.map);
        }
    }

    static class DefinitionsBuilder
    extends AbstractKeywordBuilder<String, JsonSchema> {
        DefinitionsBuilder(JsonBuilderFactory factory) {
            super(factory);
        }

        @Override
        void append(String key, JsonSchema value) {
            super.append(key, value);
            this.objectBuilder.add(key, value.toJson());
        }

        @Override
        public SchemaKeyword build() {
            return new Definitions((JsonValue)this.toJson(), this.map);
        }
    }

    static abstract class AbstractKeywordBuilder<K, V>
    implements KeywordBuilder {
        protected final Map<K, V> map = new LinkedHashMap();
        protected final JsonObjectBuilder objectBuilder;

        AbstractKeywordBuilder(JsonBuilderFactory factory) {
            this.objectBuilder = factory.createObjectBuilder();
        }

        void append(K key, V value) {
            this.map.put(key, value);
        }

        void append(Map<K, V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.append(entry.getKey(), entry.getValue());
            }
        }

        JsonObject toJson() {
            return this.objectBuilder.build();
        }
    }
}

