/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaResolver;

public class SchemaCatalog
implements JsonSchemaResolver {
    private final Map<URI, JsonSchema> map = new HashMap<URI, JsonSchema>();

    public void addSchema(JsonSchema schema) {
        if (schema.hasAbsoluteId()) {
            this.map.put(SchemaCatalog.normalizeId(schema.id()), schema);
        }
    }

    @Override
    public JsonSchema resolveSchema(URI id) {
        if (id.isAbsolute()) {
            return this.map.get(SchemaCatalog.normalizeId(id));
        }
        return null;
    }

    private static URI normalizeId(URI id) {
        if (id.getFragment() == null) {
            return id.resolve("#");
        }
        return id;
    }
}

