/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.api.ProblemHandlerFactory;
import org.leadpony.justify.api.ValidationConfig;
import org.leadpony.justify.internal.base.Arguments;

public class DefaultValidationConfig
extends HashMap<String, Object>
implements ValidationConfig {
    @Override
    public Map<String, Object> getAsMap() {
        return Collections.unmodifiableMap(this);
    }

    @Override
    public Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.get(name));
    }

    @Override
    public ValidationConfig setProperty(String name, Object value) {
        Arguments.requireNonNull(name, "name");
        this.put(name, value);
        return this;
    }

    @Override
    public ValidationConfig withProperties(Map<String, ?> properties) {
        if (properties != null) {
            this.putAll(properties);
        }
        return this;
    }

    @Override
    public ValidationConfig withSchema(JsonSchema schema) {
        Arguments.requireNonNull(schema, "schema");
        return this.setProperty("org.leadpony.justify.api.ValidationConfig.SCHEMA", schema);
    }

    @Override
    public ValidationConfig withProblemHandler(ProblemHandler handler) {
        Arguments.requireNonNull(handler, "handler");
        return this.withProblemHandlerFactory(p -> handler);
    }

    @Override
    public ValidationConfig withProblemHandlerFactory(ProblemHandlerFactory handlerFactory) {
        Arguments.requireNonNull(handlerFactory, "handlerFactory");
        return this.setProperty("org.leadpony.justify.api.ValidationConfig.PROBLEM_HANDLER_FACTORY", handlerFactory);
    }

    @Override
    public ValidationConfig withDefaultValues(boolean usingDefaultValues) {
        return this.setProperty("org.leadpony.justify.api.ValidationConfig.DEFAULT_VALUES", usingDefaultValues);
    }
}

