/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.validator;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.ProblemHandlerFactory;
import org.leadpony.justify.internal.base.json.JsonParserFactoryDecorator;
import org.leadpony.justify.internal.validator.DefaultizingJsonValidator;
import org.leadpony.justify.internal.validator.JsonValidator;

public class JsonValidatorFactory
extends JsonParserFactoryDecorator {
    private final JsonSchema schema;
    private final JsonProvider jsonProvider;
    private final ProblemHandlerFactory handlerFactory;
    private final Map<String, ?> properties;
    private static final ProblemHandlerFactory DEFAULT_HANDLER_FACTORY = parser -> problems -> {};

    public JsonValidatorFactory(JsonSchema schema, JsonProvider jsonProvider, JsonParserFactory jsonParserFactory, ProblemHandlerFactory handlerFactory, Map<String, Object> properties) {
        super(jsonParserFactory);
        this.schema = schema;
        this.jsonProvider = jsonProvider;
        this.handlerFactory = handlerFactory;
        this.properties = properties;
    }

    public JsonValidatorFactory(JsonProvider jsonProvider, JsonParserFactory realFactory, Map<String, ?> properties) {
        super(realFactory);
        this.jsonProvider = jsonProvider;
        this.properties = properties;
        this.schema = (JsonSchema)properties.get("org.leadpony.justify.api.ValidationConfig.SCHEMA");
        ProblemHandlerFactory handlerFactory = (ProblemHandlerFactory)properties.get("org.leadpony.justify.api.ValidationConfig.PROBLEM_HANDLER_FACTORY");
        ProblemHandlerFactory problemHandlerFactory = this.handlerFactory = handlerFactory != null ? handlerFactory : DEFAULT_HANDLER_FACTORY;
        assert (this.schema != null);
    }

    @Override
    public JsonValidator createParser(Reader reader) {
        JsonParser parser = super.createParser(reader);
        return this.createValiator(parser);
    }

    @Override
    public JsonValidator createParser(InputStream in) {
        JsonParser parser = super.createParser(in);
        return this.createValiator(parser);
    }

    @Override
    public JsonValidator createParser(JsonObject obj) {
        JsonParser parser = super.createParser(obj);
        return this.createValiator(parser);
    }

    @Override
    public JsonValidator createParser(JsonArray array) {
        JsonParser parser = super.createParser(array);
        return this.createValiator(parser);
    }

    @Override
    public JsonValidator createParser(InputStream in, Charset charset) {
        JsonParser parser = super.createParser(in, charset);
        return this.createValiator(parser);
    }

    private boolean usesDefaultValues() {
        Object value = this.properties.get("org.leadpony.justify.api.ValidationConfig.DEFAULT_VALUES");
        return value == Boolean.TRUE;
    }

    private JsonValidator createValiator(JsonParser parser) {
        JsonValidator validator = this.newValidator(parser);
        return validator.withHandler(this.handlerFactory.createProblemHandler(validator));
    }

    private JsonValidator newValidator(JsonParser parser) {
        if (this.usesDefaultValues()) {
            return new DefaultizingJsonValidator(parser, this.schema, this.jsonProvider);
        }
        return new JsonValidator(parser, this.schema, this.jsonProvider);
    }
}

