/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.spi;

import jakarta.json.JsonException;
import jakarta.json.spi.JsonProvider;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.leadpony.justify.api.JsonValidationService;

public abstract class JsonValidationProvider {
    public static JsonValidationProvider provider() {
        JsonValidationProvider provider = JsonValidationProvider.loadProvider(Thread.currentThread().getContextClassLoader());
        if (provider == null && (provider = JsonValidationProvider.loadProvider(JsonValidationProvider.class.getClassLoader())) == null) {
            throw new JsonException("JSON validation provider was not found.");
        }
        return provider;
    }

    protected JsonValidationProvider() {
    }

    public abstract JsonValidationService createService();

    public abstract JsonValidationService createService(JsonProvider var1);

    private static JsonValidationProvider loadProvider(ClassLoader classLoader) {
        ServiceLoader<JsonValidationProvider> loader = ServiceLoader.load(JsonValidationProvider.class, classLoader);
        Iterator<JsonValidationProvider> it = loader.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

