/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.report.render;

import ambience.adhocreport.AdHocReportModule;
import ambience.adhocreport.Model;
import ambience.adhocreport.Util$;
import ambience.adhocreport.report.agg.pagination.PageManager;
import ambience.adhocreport.report.db.AdhocReportDB$;
import ambience.adhocreport.report.render.ReportRenderer$;
import ambience.adhocreport.report.render.ReportRenderer$RenderContext$;
import ambience.adhocreport.report.render.html.ReportBuilder;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.Format;
import com.elixirtech.vdom.VNode;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ReportRenderer {
    private final AdHocReportModule.AdhocReportContext cxt;
    private final Data.Schema schema;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ReportRenderer$.class.getDeclaredField("log$lzy1"));

    public static Option<ReportBuilder> getReportBuilder(Model.LayoutType layoutType) {
        return ReportRenderer$.MODULE$.getReportBuilder(layoutType);
    }

    public static LoggingInterface log() {
        return ReportRenderer$.MODULE$.log();
    }

    public ReportRenderer(AdHocReportModule.AdhocReportContext cxt, Data.Schema schema) {
        this.cxt = cxt;
        this.schema = schema;
    }

    public Task<Either<LogMessage, VNode>> buildReport() {
        Option<ReportBuilder> option = ReportRenderer$.MODULE$.getReportBuilder(this.cxt.request().layoutType());
        if (option instanceof Some) {
            ReportBuilder reportBuilder = (ReportBuilder)((Some)option).value();
            return new PageManager(this.cxt.request(), reportBuilder, this.schema).getRowIndexingResult().flatMap((Function1 & Serializable)pageInfo -> this.getDocs(this.cxt.request(), reportBuilder, (PageManager.PageInfo)pageInfo, this.cxt.user()).flatMap((Function1 & Serializable)docs -> Task$.MODULE$.apply(() -> this.buildReport$$anonfun$1$$anonfun$1$$anonfun$1(docs, reportBuilder, pageInfo)).map((Function1 & Serializable)report -> report)));
        }
        if (None$.MODULE$.equals(option)) {
            return this.errGetReportBuilder(this.cxt.request().layoutType());
        }
        throw new MatchError(option);
    }

    public Task<List<Document>> getDocs(Model.ReportRequest request, ReportBuilder reportBuilder, PageManager.PageInfo pageInfo, UserDB.User user) {
        List<Bson> agg = reportBuilder.buildAgg(request, pageInfo, this.schema);
        return AdhocReportDB$.MODULE$.fetchReportData(request.cltnName(), agg, user).toListL();
    }

    private Left<LogMessage.Error, VNode> errBuildReport(int docsLength, int limitRecords) {
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unable to render report. Total records(" + docsLength + ") over limit (" + limitRecords + ")"));
    }

    private Task<Left<LogMessage.Error, Nothing$>> errGetReportBuilder(Model.LayoutType layoutType) {
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unable to build report for layout type:" + layoutType)));
    }

    private Right<LogMessage.Error, VNode> buildReport(ReportBuilder builder, List<Document> docs, PageManager.PageInfo pageInfo) {
        RenderContext renderCxt = this.buildRenderContext(this.cxt.request(), this.schema, pageInfo);
        List docs2 = docs.map((Function1 & Serializable)doc -> this.handleId(this.cxt.request().hasOriginalId(), (Document)doc));
        return package$.MODULE$.Right().apply((Object)builder.buildReport((List<Document>)docs2, renderCxt));
    }

    private RenderContext buildRenderContext(Model.ReportRequest request, Data.Schema schema, PageManager.PageInfo rowIndexingResult) {
        return ReportRenderer$RenderContext$.MODULE$.apply((List<Model.AdhocField>)request.adhocFields(), (List<Model.DimGroup>)request.groups(), (List<Model.DimField>)request.fields(), schema, request.getDisplay(), request.preview(), request.tableProperties(), request.timeZone(), Format.Context$.MODULE$.apply(request.calendar()), rowIndexingResult, request.drillDownPath());
    }

    private Document handleId(boolean hasOriginalId, Document doc) {
        if (hasOriginalId) {
            Option option = doc.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)Util$.MODULE$.OriginalId());
            if (option instanceof Some) {
                BsonValue v = (BsonValue)((Some)option).value();
                return (Document)((BaseDocument)doc.filterKeys((Function1 & Serializable)_$5 -> {
                    String string = _$5;
                    String string2 = Util$.MODULE$.Id();
                    return string == null ? string2 != null : !string.equals(string2);
                })).updated(Util$.MODULE$.Id(), (Object)v, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            }
            if (None$.MODULE$.equals(option)) {
                return doc;
            }
            throw new MatchError((Object)option);
        }
        return doc;
    }

    private final Either buildReport$$anonfun$1$$anonfun$1$$anonfun$1(List docs$1, ReportBuilder reportBuilder$2, PageManager.PageInfo pageInfo$1) {
        if (docs$1.length() > this.cxt.limitRecords()) {
            return this.errBuildReport(docs$1.length(), this.cxt.limitRecords());
        }
        return this.buildReport(reportBuilder$2, (List<Document>)docs$1, pageInfo$1);
    }

    public static final class RenderContext
    implements Product,
    Serializable {
        private final List adhocFields;
        private final List groups;
        private final List fields;
        private final Data.Schema schema;
        private final Model.Display display;
        private final Model.Preview preview;
        private final Model.TableProperties tableProperties;
        private final String timeZone;
        private final Format.Context formatCxt;
        private final PageManager.PageInfo pageInfo;
        private final Model.Path drillDownPath;

        public static RenderContext apply(List<Model.AdhocField> list, List<Model.DimGroup> list2, List<Model.DimField> list3, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String string, Format.Context context, PageManager.PageInfo pageInfo, Model.Path path) {
            return ReportRenderer$RenderContext$.MODULE$.apply(list, list2, list3, schema, display, preview, tableProperties, string, context, pageInfo, path);
        }

        public static RenderContext fromProduct(Product product) {
            return ReportRenderer$RenderContext$.MODULE$.fromProduct(product);
        }

        public static RenderContext unapply(RenderContext renderContext) {
            return ReportRenderer$RenderContext$.MODULE$.unapply(renderContext);
        }

        public RenderContext(List<Model.AdhocField> adhocFields, List<Model.DimGroup> groups, List<Model.DimField> fields, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String timeZone, Format.Context formatCxt, PageManager.PageInfo pageInfo, Model.Path drillDownPath) {
            this.adhocFields = adhocFields;
            this.groups = groups;
            this.fields = fields;
            this.schema = schema;
            this.display = display;
            this.preview = preview;
            this.tableProperties = tableProperties;
            this.timeZone = timeZone;
            this.formatCxt = formatCxt;
            this.pageInfo = pageInfo;
            this.drillDownPath = drillDownPath;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderContext)) return false;
            RenderContext renderContext = (RenderContext)object;
            List<Model.AdhocField> list = this.adhocFields();
            List<Model.AdhocField> list2 = renderContext.adhocFields();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<Model.DimGroup> list3 = this.groups();
            List<Model.DimGroup> list4 = renderContext.groups();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            List<Model.DimField> list5 = this.fields();
            List<Model.DimField> list6 = renderContext.fields();
            if (list5 == null) {
                if (list6 != null) {
                    return false;
                }
            } else if (!list5.equals(list6)) return false;
            Data.Schema schema = this.schema();
            Data.Schema schema2 = renderContext.schema();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!schema.equals(schema2)) return false;
            Model.Display display = this.display();
            Model.Display display2 = renderContext.display();
            if (display == null) {
                if (display2 != null) {
                    return false;
                }
            } else if (!display.equals(display2)) return false;
            Model.Preview preview = this.preview();
            Model.Preview preview2 = renderContext.preview();
            if (preview == null) {
                if (preview2 != null) {
                    return false;
                }
            } else if (!preview.equals(preview2)) return false;
            Model.TableProperties tableProperties = this.tableProperties();
            Model.TableProperties tableProperties2 = renderContext.tableProperties();
            if (tableProperties == null) {
                if (tableProperties2 != null) {
                    return false;
                }
            } else if (!tableProperties.equals(tableProperties2)) return false;
            String string = this.timeZone();
            String string2 = renderContext.timeZone();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Format.Context context = this.formatCxt();
            Format.Context context2 = renderContext.formatCxt();
            if (context == null) {
                if (context2 != null) {
                    return false;
                }
            } else if (!context.equals(context2)) return false;
            PageManager.PageInfo pageInfo = this.pageInfo();
            PageManager.PageInfo pageInfo2 = renderContext.pageInfo();
            if (pageInfo == null) {
                if (pageInfo2 != null) {
                    return false;
                }
            } else if (!((Object)pageInfo).equals(pageInfo2)) return false;
            Model.Path path = this.drillDownPath();
            Model.Path path2 = renderContext.drillDownPath();
            if (path == null) {
                if (path2 == null) return true;
                return false;
            } else {
                if (!path.equals(path2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderContext;
        }

        public int productArity() {
            return 11;
        }

        public String productPrefix() {
            return "RenderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "adhocFields";
                }
                case 1: {
                    return "groups";
                }
                case 2: {
                    return "fields";
                }
                case 3: {
                    return "schema";
                }
                case 4: {
                    return "display";
                }
                case 5: {
                    return "preview";
                }
                case 6: {
                    return "tableProperties";
                }
                case 7: {
                    return "timeZone";
                }
                case 8: {
                    return "formatCxt";
                }
                case 9: {
                    return "pageInfo";
                }
                case 10: {
                    return "drillDownPath";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Model.AdhocField> adhocFields() {
            return this.adhocFields;
        }

        public List<Model.DimGroup> groups() {
            return this.groups;
        }

        public List<Model.DimField> fields() {
            return this.fields;
        }

        public Data.Schema schema() {
            return this.schema;
        }

        public Model.Display display() {
            return this.display;
        }

        public Model.Preview preview() {
            return this.preview;
        }

        public Model.TableProperties tableProperties() {
            return this.tableProperties;
        }

        public String timeZone() {
            return this.timeZone;
        }

        public Format.Context formatCxt() {
            return this.formatCxt;
        }

        public PageManager.PageInfo pageInfo() {
            return this.pageInfo;
        }

        public Model.Path drillDownPath() {
            return this.drillDownPath;
        }

        public Option<Model.AdhocField> getAdhocField(String fieldName) {
            return this.adhocFields().find((Function1 & Serializable)_$1 -> {
                String string = _$1.name();
                String string2 = fieldName;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
        }

        public int totalColumns() {
            return this.groups().length() + this.fields().length();
        }

        public boolean isDisplay(Model.Display display) {
            Model.Display display2 = this.display();
            Model.Display display3 = display;
            return !(display2 != null ? !display2.equals(display3) : display3 != null);
        }

        public Option<Json> getFieldProp(int idx) {
            return ((Option)this.fields().lift().apply((Object)BoxesRunTime.boxToInteger((int)idx))).map((Function1 & Serializable)_$2 -> _$2.cellProperties());
        }

        public Data.Type getFieldType(String fieldName) {
            return (Data.Type)this.schema().fields().find((Function1 & Serializable)_$3 -> {
                String string = _$3.name();
                String string2 = fieldName;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$4 -> _$4.dataType()).getOrElse(this::getFieldType$$anonfun$3);
        }

        public RenderContext copy(List<Model.AdhocField> adhocFields, List<Model.DimGroup> groups, List<Model.DimField> fields, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String timeZone, Format.Context formatCxt, PageManager.PageInfo pageInfo, Model.Path drillDownPath) {
            return new RenderContext(adhocFields, groups, fields, schema, display, preview, tableProperties, timeZone, formatCxt, pageInfo, drillDownPath);
        }

        public List<Model.AdhocField> copy$default$1() {
            return this.adhocFields();
        }

        public List<Model.DimGroup> copy$default$2() {
            return this.groups();
        }

        public List<Model.DimField> copy$default$3() {
            return this.fields();
        }

        public Data.Schema copy$default$4() {
            return this.schema();
        }

        public Model.Display copy$default$5() {
            return this.display();
        }

        public Model.Preview copy$default$6() {
            return this.preview();
        }

        public Model.TableProperties copy$default$7() {
            return this.tableProperties();
        }

        public String copy$default$8() {
            return this.timeZone();
        }

        public Format.Context copy$default$9() {
            return this.formatCxt();
        }

        public PageManager.PageInfo copy$default$10() {
            return this.pageInfo();
        }

        public Model.Path copy$default$11() {
            return this.drillDownPath();
        }

        public List<Model.AdhocField> _1() {
            return this.adhocFields();
        }

        public List<Model.DimGroup> _2() {
            return this.groups();
        }

        public List<Model.DimField> _3() {
            return this.fields();
        }

        public Data.Schema _4() {
            return this.schema();
        }

        public Model.Display _5() {
            return this.display();
        }

        public Model.Preview _6() {
            return this.preview();
        }

        public Model.TableProperties _7() {
            return this.tableProperties();
        }

        public String _8() {
            return this.timeZone();
        }

        public Format.Context _9() {
            return this.formatCxt();
        }

        public PageManager.PageInfo _10() {
            return this.pageInfo();
        }

        public Model.Path _11() {
            return this.drillDownPath();
        }

        private final Data.Type getFieldType$$anonfun$3() {
            return Data.Unknown$.MODULE$;
        }
    }
}

