/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.report.xlsx.builder.drilldown;

import ambience.adhocreport.report.xlsx.RowExtract;
import ambience.adhocreport.report.xlsx.RowExtract$CellContentLink$;
import ambience.adhocreport.report.xlsx.XlsxBuilder;
import ambience.adhocreport.report.xlsx.XlsxSheet;
import ambience.adhocreport.report.xlsx.builder.BaseBuilder;
import ambience.adhocreport.report.xlsx.builder.BaseBuilder$CellFinish$;
import ambience.adhocreport.report.xlsx.builder.BaseBuilder$RowContext$;
import ambience.adhocreport.report.xlsx.builder.BaseExtractor;
import ambience.adhocreport.report.xlsx.builder.drilldown.DrillDownBuilder$;
import ambience.adhocreport.report.xlsx.builder.drilldown.DrillDownBuilder$GroupRows$;
import ambience.adhocreport.report.xlsx.builder.drilldown.DrillDownExtractor;
import ambience.adhocreport.report.xlsx.builder.util.XlsxStyleBuilder;
import java.io.Serializable;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class DrillDownBuilder
extends BaseBuilder {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DrillDownBuilder.class.getDeclaredField("Extractor$lzy1"));
    private final XlsxBuilder.XlsxContext xlsxCxt;
    private final XlsxBuilder xBuilder;
    private volatile Object Extractor$lzy1;
    private final List<GroupRows> GroupedRows;

    public static DrillDownBuilder apply(XlsxBuilder.XlsxContext xlsxContext, XlsxBuilder xlsxBuilder) {
        return DrillDownBuilder$.MODULE$.apply(xlsxContext, xlsxBuilder);
    }

    public DrillDownBuilder(XlsxBuilder.XlsxContext xlsxCxt, XlsxBuilder xBuilder) {
        this.xlsxCxt = xlsxCxt;
        this.xBuilder = xBuilder;
        this.GroupedRows = ((List)this.Extractor().sheetTables().zipWithIndex()).flatMap((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                BaseExtractor.SheetTable sheet = (BaseExtractor.SheetTable)tuple2._1();
                int groupIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return sheet.rows().grouped(this.RowPerSheetLimit()).zipWithIndex().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        List rows = (List)tuple2._1();
                        int sheetIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        return DrillDownBuilder$GroupRows$.MODULE$.apply((List<RowExtract.BaseRow>)rows, groupIdx, sheetIdx, sheet.path());
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
        this.GroupedRows.foreach((Function1)(JProcedure1 & Serializable)groupRows -> this.buildSheet((GroupRows)groupRows));
    }

    @Override
    public XlsxBuilder.XlsxContext xlsxCxt() {
        return this.xlsxCxt;
    }

    @Override
    public XlsxBuilder xBuilder() {
        return this.xBuilder;
    }

    @Override
    public DrillDownExtractor Extractor() {
        Object object = this.Extractor$lzy1;
        if (object instanceof DrillDownExtractor) {
            return (DrillDownExtractor)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DrillDownExtractor)this.Extractor$lzyINIT1();
    }

    private Object Extractor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Extractor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DrillDownExtractor drillDownExtractor = null;
                    try {
                        drillDownExtractor = new DrillDownExtractor(this.xlsxCxt());
                        object2 = drillDownExtractor == null ? LazyVals.NullValue$.MODULE$ : drillDownExtractor;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Extractor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return drillDownExtractor;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void buildSheet(GroupRows groupRows) {
        XlsxSheet sheet = this.prepareSheet(groupRows);
        List cellCompletions = ((List)groupRows.rows().zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseRow row = (RowExtract.BaseRow)tuple2._1();
                int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                BaseBuilder.RowContext rowCxt = BaseBuilder$RowContext$.MODULE$.apply(sheet, row, rowIdx);
                RowExtract.BaseRow baseRow = row;
                if (baseRow instanceof RowExtract.Row) {
                    return this.buildRow(rowCxt);
                }
                if (baseRow instanceof RowExtract.BreadCrumbRow) {
                    return this.buildBreadcrumbRow(rowCxt);
                }
                throw new MatchError((Object)baseRow);
            }
            throw new MatchError((Object)tuple2);
        });
        sheet.autoSize();
        this.handleCellSize((List<BaseBuilder.CellResult>)cellCompletions, sheet.currentSheet());
    }

    @Override
    public List<BaseBuilder.CellResult> buildRow(BaseBuilder.RowContext rowCxt) {
        XlsxStyleBuilder xStyle = this.getXlsxStyleBuilder(rowCxt.row(), this.xlsxCxt().exportCxt());
        this.setRowStyles(rowCxt.rowX(), xStyle.RowStyleMap());
        return this.fillCells(rowCxt, xStyle);
    }

    @Override
    public List<BaseBuilder.CellResult> fillCells(BaseBuilder.RowContext cxt, XlsxStyleBuilder xStyle) {
        return ((List)cxt.row().cellContents().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseCellContent cellContent = (RowExtract.BaseCellContent)tuple2._1();
                int cellIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                XSSFCell cellX = cxt.rowX().addCell(cellIdx);
                xStyle.setCellStyle(cellX, cellIdx);
                return this.setCellContent(cxt, cellContent, cellX, cellIdx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<BaseBuilder.CellResult> buildBreadcrumbRow(BaseBuilder.RowContext rowCxt) {
        XlsxStyleBuilder xStyle = this.getXlsxStyleBuilder(rowCxt.row(), this.xlsxCxt().exportCxt());
        this.setRowStyles(rowCxt.rowX(), xStyle.RowStyleMap());
        return rowCxt.row().cellContents().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(RowExtract.BaseCellContent x) {
                RowExtract.BaseCellContent baseCellContent = x;
                if (baseCellContent instanceof RowExtract.CellContentLink) {
                    RowExtract.CellContentLink c = (RowExtract.CellContentLink)baseCellContent;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(RowExtract.BaseCellContent x, Function1 function1) {
                RowExtract.BaseCellContent baseCellContent = x;
                if (baseCellContent instanceof RowExtract.CellContentLink) {
                    RowExtract.CellContentLink c = (RowExtract.CellContentLink)baseCellContent;
                    return c;
                }
                return function1.apply((Object)x);
            }
        }).flatMap((Function1 & Serializable)cell -> this.fillCellsBreadcrumb(rowCxt, xStyle, (RowExtract.CellContentLink)cell));
    }

    private List<BaseBuilder.CellResult> fillCellsBreadcrumb(BaseBuilder.RowContext rowCxt, XlsxStyleBuilder xStyle, RowExtract.CellContentLink cell) {
        return ((List)cell.splitContent().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String content = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                XSSFCell cellX = rowCxt.rowX().addCell(idx);
                cellX.setCellValue(content);
                xStyle.setCellStyle(cellX, idx);
                this.setHyperlink(cell, cellX, idx);
                return BaseBuilder$CellFinish$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String buildBreadcrumbPath(String path, int groupIdx, int sheetIdx) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])path.split(","));
        String pathInitial = Predef$.MODULE$.wrapCharArray((char[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$1 -> StringOps$.MODULE$.headOption$extension(Predef$.MODULE$.augmentString(_$1)), ClassTag$.MODULE$.apply(Character.TYPE))).mkString("");
        Object groupIdxStr = groupIdx == 0 ? "" : "_" + groupIdx;
        return pathInitial + "_" + (sheetIdx + 1) + (String)groupIdxStr;
    }

    @Override
    public BaseBuilder.CellResult setCellContent(BaseBuilder.RowContext cxt, RowExtract.BaseCellContent cellContent, XSSFCell cellX, int cellIdx) {
        RowExtract.BaseCellContent baseCellContent = cellContent;
        if (baseCellContent instanceof RowExtract.CellContentLink) {
            RowExtract.CellContentLink cellContentLink = RowExtract$CellContentLink$.MODULE$.unapply((RowExtract.CellContentLink)baseCellContent);
            String string = cellContentLink._1();
            String string2 = cellContentLink._2();
            String content = string;
            String link = string2;
            cellX.setCellValue(content);
            this.setHyperlink(cellX, link);
            return BaseBuilder$CellFinish$.MODULE$;
        }
        return super.setCellContent(cxt, cellContent, cellX, cellIdx);
    }

    private void setHyperlink(RowExtract.CellContentLink cell, XSSFCell cellX, int idx) {
        String path = cell.splitContent().take(idx + 1).mkString(",");
        this.setHyperlink(cellX, path);
    }

    private void setHyperlink(XSSFCell cellX, String link) {
        this.GroupedRows.find((Function1 & Serializable)_$2 -> {
            String string = _$2.path();
            String string2 = link;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1)(JProcedure1 & Serializable)gp -> {
            XSSFHyperlink hyperLink = this.xBuilder().wb().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            String sheetName = this.buildBreadcrumbPath(gp.path(), gp.groupIdx(), gp.sheetIdx());
            hyperLink.setAddress(sheetName + "!A1");
            cellX.setHyperlink((Hyperlink)hyperLink);
        });
    }

    private XlsxSheet prepareSheet(GroupRows groupRows) {
        String sheetName = this.buildBreadcrumbPath(groupRows.path(), groupRows.groupIdx(), groupRows.sheetIdx());
        return new XlsxSheet(this.xBuilder().wb().createSheet(sheetName));
    }

    @Override
    public void buildSheet(List<RowExtract.BaseRow> rows, int sheetIdx) {
    }

    public static final class GroupRows
    implements Product,
    Serializable {
        private final List rows;
        private final int groupIdx;
        private final int sheetIdx;
        private final String path;

        public static GroupRows apply(List<RowExtract.BaseRow> list, int n, int n2, String string) {
            return DrillDownBuilder$GroupRows$.MODULE$.apply(list, n, n2, string);
        }

        public static GroupRows fromProduct(Product product) {
            return DrillDownBuilder$GroupRows$.MODULE$.fromProduct(product);
        }

        public static GroupRows unapply(GroupRows groupRows) {
            return DrillDownBuilder$GroupRows$.MODULE$.unapply(groupRows);
        }

        public GroupRows(List<RowExtract.BaseRow> rows, int groupIdx, int sheetIdx, String path) {
            this.rows = rows;
            this.groupIdx = groupIdx;
            this.sheetIdx = sheetIdx;
            this.path = path;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.rows()));
            n = Statics.mix((int)n, (int)this.groupIdx());
            n = Statics.mix((int)n, (int)this.sheetIdx());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GroupRows)) return false;
            GroupRows groupRows = (GroupRows)object;
            if (this.groupIdx() != groupRows.groupIdx()) return false;
            if (this.sheetIdx() != groupRows.sheetIdx()) return false;
            List<RowExtract.BaseRow> list = this.rows();
            List<RowExtract.BaseRow> list2 = groupRows.rows();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            String string = this.path();
            String string2 = groupRows.path();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GroupRows;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "GroupRows";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "rows";
                }
                case 1: {
                    return "groupIdx";
                }
                case 2: {
                    return "sheetIdx";
                }
                case 3: {
                    return "path";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<RowExtract.BaseRow> rows() {
            return this.rows;
        }

        public int groupIdx() {
            return this.groupIdx;
        }

        public int sheetIdx() {
            return this.sheetIdx;
        }

        public String path() {
            return this.path;
        }

        public GroupRows copy(List<RowExtract.BaseRow> rows, int groupIdx, int sheetIdx, String path) {
            return new GroupRows(rows, groupIdx, sheetIdx, path);
        }

        public List<RowExtract.BaseRow> copy$default$1() {
            return this.rows();
        }

        public int copy$default$2() {
            return this.groupIdx();
        }

        public int copy$default$3() {
            return this.sheetIdx();
        }

        public String copy$default$4() {
            return this.path();
        }

        public List<RowExtract.BaseRow> _1() {
            return this.rows();
        }

        public int _2() {
            return this.groupIdx();
        }

        public int _3() {
            return this.sheetIdx();
        }

        public String _4() {
            return this.path();
        }
    }
}

