/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.report.xlsx.builder.util;

import ambience.adhocreport.Style$;
import ambience.adhocreport.report.xlsx.builder.util.XlsxColorUtil;
import ambience.adhocreport.report.xlsx.builder.util.XlsxColorUtil$Context$;
import ambience.adhocreport.report.xlsx.builder.util.XlsxStyleBuilder;
import ambience.adhocreport.report.xlsx.builder.util.XlsxStyleBuilder$RGB$;
import java.awt.Color;
import java.io.Serializable;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class XlsxColorUtil$
implements Serializable {
    public static final XlsxColorUtil$Context$ Context;
    public static final XlsxColorUtil$ MODULE$;

    private XlsxColorUtil$() {
    }

    static {
        MODULE$ = new XlsxColorUtil$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XlsxColorUtil$.class);
    }

    public Option<XSSFColor> getColor(XlsxColorUtil.Context cxt) {
        Map<String, String> cellStyles = cxt.cellStyles();
        return cellStyles.get((Object)cxt.colorPropertyName()).flatMap((Function1 & Serializable)colorStr -> {
            Option opacityOpt = cellStyles.get((Object)Style$.MODULE$.OPACITY()).map((Function1 & Serializable)str -> this.removeLetters((String)str)).flatMap((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(_$1)));
            return this.extractColorFromString((String)colorStr, (Option<Object>)opacityOpt, cxt.colorMap());
        });
    }

    public Option<XSSFColor> extractColorFromString(String colorValueStr, Option<Object> opacityOpt, IndexedColorMap colorMap) {
        Object[] objectArray;
        if (colorValueStr.startsWith("rgb(")) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(colorValueStr), "rgb(")), ")")), ','));
            objectArray = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.trim(), ClassTag$.MODULE$.apply(String.class));
        } else if (colorValueStr.startsWith("rgba(")) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(colorValueStr), "rgba(")), ")")), ','));
            objectArray = (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.trim(), ClassTag$.MODULE$.apply(String.class));
        } else {
            objectArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        Object[] rgbValuesArr = objectArray;
        Object object = Predef$.MODULE$.refArrayOps(rgbValuesArr);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
            double value;
            Option<Object> option = opacityOpt;
            double opacity = option instanceof Some ? (value = BoxesRunTime.unboxToDouble((Object)((Some)option).value())) : (None$.MODULE$.equals(option) && rgbValuesArr.length > 3 ? BoxesRunTime.unboxToDouble((Object)StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString((String)rgbValuesArr[3])).getOrElse(this::$anonfun$5)) : 1.0);
            XlsxStyleBuilder.RGB oriRGB = XlsxStyleBuilder$RGB$.MODULE$.apply(this.colorStrToInt$1((String)rgbValuesArr[0]), this.colorStrToInt$1((String)rgbValuesArr[1]), this.colorStrToInt$1((String)rgbValuesArr[2]));
            XlsxStyleBuilder.RGB newRGB = this.applyOpacityOnRGB(oriRGB, opacity, this.applyOpacityOnRGB$default$3());
            Color jColor = new Color(newRGB.r(), newRGB.g(), newRGB.b());
            return Try$.MODULE$.apply(() -> this.extractColorFromString$$anonfun$1(jColor, colorMap)).toOption();
        }
        return None$.MODULE$;
    }

    public XlsxStyleBuilder.RGB applyOpacityOnRGB(XlsxStyleBuilder.RGB oriColor, double opacity, XlsxStyleBuilder.RGB bgColor) {
        int r = this.applyOpacity$1(Int$.MODULE$.int2double(oriColor.r()), Int$.MODULE$.int2double(bgColor.r()), opacity);
        int g = this.applyOpacity$1(Int$.MODULE$.int2double(oriColor.g()), Int$.MODULE$.int2double(bgColor.g()), opacity);
        int b = this.applyOpacity$1(Int$.MODULE$.int2double(oriColor.b()), Int$.MODULE$.int2double(bgColor.b()), opacity);
        return XlsxStyleBuilder$RGB$.MODULE$.apply(r, g, b);
    }

    public XlsxStyleBuilder.RGB applyOpacityOnRGB$default$3() {
        return XlsxStyleBuilder$RGB$.MODULE$.apply(255, 255, 255);
    }

    public String removeLetters(String str) {
        return str.replaceAll("[a-zA-Z]", "");
    }

    private final int colorStrToInt$1(String str) {
        return (int)package$.MODULE$.round(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(str)));
    }

    private final double $anonfun$5() {
        return 1.0;
    }

    private final XSSFColor extractColorFromString$$anonfun$1(Color jColor$1, IndexedColorMap colorMap$1) {
        return new XSSFColor(jColor$1, colorMap$1);
    }

    private final int applyOpacity$1(double color, double bgColor, double opacity) {
        double c = color * opacity;
        double c2 = (1.0 - opacity) * bgColor;
        return (int)package$.MODULE$.round(c + c2);
    }
}

