/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.bouncycastle.extensions.PGPKeyRingExtensionsKt;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.modification.secretkeyring.SecretKeyRingEditor;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.key.util.RevocationAttributes;
import org.pgpainless.sop.KeyReader;
import org.pgpainless.sop.MatchMakingSecretKeyRingProtector;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.Passphrase;
import sop.Ready;
import sop.exception.SOPGPException;
import sop.operation.RevokeKey;
import sop.util.UTF8Util;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/pgpainless/sop/RevokeKeyImpl;", "Lsop/operation/RevokeKey;", "()V", "armor", "", "protector", "Lorg/pgpainless/sop/MatchMakingSecretKeyRingProtector;", "keys", "Lsop/Ready;", "Ljava/io/InputStream;", "noArmor", "withKeyPassword", "password", "", "pgpainless-sop"})
@SourceDebugExtension(value={"SMAP\nRevokeKeyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevokeKeyImpl.kt\norg/pgpainless/sop/RevokeKeyImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1855#2,2:97\n1855#2,2:99\n1#3:101\n*S KotlinDebug\n*F\n+ 1 RevokeKeyImpl.kt\norg/pgpainless/sop/RevokeKeyImpl\n*L\n39#1:97,2\n42#1:99,2\n*E\n"})
public final class RevokeKeyImpl
implements RevokeKey {
    @NotNull
    private final MatchMakingSecretKeyRingProtector protector = new MatchMakingSecretKeyRingProtector();
    private boolean armor = true;

    @NotNull
    public Ready keys(@NotNull InputStream keys2) {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection;
        Intrinsics.checkNotNullParameter((Object)keys2, (String)"keys");
        try {
            pGPSecretKeyRingCollection = KeyReader.Companion.readSecretKeys(keys2, true);
        }
        catch (IOException e) {
            throw new SOPGPException.BadData("Cannot decode secret keys.", (Throwable)e);
        }
        PGPSecretKeyRingCollection secretKeyRings = pGPSecretKeyRingCollection;
        Iterable $this$forEach$iv = (Iterable)secretKeyRings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PGPSecretKeyRing it = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.protector.addSecretKey(it);
        }
        List revocationCertificates = new ArrayList();
        Iterable $this$forEach$iv2 = (Iterable)secretKeyRings;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)secretKeys, (String)"secretKeys");
            SecretKeyRingEditor editor = PGPainless.Companion.modifyKeyRing$default((PGPainless.Companion)PGPainless.Companion, (PGPSecretKeyRing)secretKeys, null, (int)2, null);
            try {
                RevocationAttributes attributes = RevocationAttributes.Companion.createKeyRevocation().withReason(RevocationAttributes.Reason.NO_REASON).withoutDescription();
                if (secretKeys.getPublicKey().getVersion() == 6) {
                    revocationCertificates.add(editor.createMinimalRevocationCertificate((SecretKeyRingProtector)this.protector, attributes));
                    continue;
                }
                PGPPublicKeyRing certificate = PGPainless.Companion.extractCertificate(secretKeys);
                PGPSignature revocation = editor.createRevocation((SecretKeyRingProtector)this.protector, attributes);
                revocationCertificates.add(KeyRingUtils.Companion.injectCertification((PGPKeyRing)certificate, revocation));
            }
            catch (WrongPassphraseException e) {
                throw new SOPGPException.KeyIsProtected("Missing or wrong passphrase for key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)secretKeys)), (Throwable)e);
            }
            catch (PGPException e) {
                throw new RuntimeException("Cannot generate revocation certificate for key " + PGPKeyRingExtensionsKt.getOpenPgpFingerprint((PGPKeyRing)((PGPKeyRing)secretKeys)), e);
            }
        }
        return new Ready(revocationCertificates, this){
            final /* synthetic */ List<PGPPublicKeyRing> $revocationCertificates;
            final /* synthetic */ RevokeKeyImpl this$0;
            {
                this.$revocationCertificates = $revocationCertificates;
                this.this$0 = $receiver;
            }

            public void writeTo(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection((Collection)this.$revocationCertificates);
                if (RevokeKeyImpl.access$getArmor$p(this.this$0)) {
                    ArmoredOutputStream armorOut = ArmoredOutputStreamFactory.Companion.get$default((ArmoredOutputStreamFactory.Companion)ArmoredOutputStreamFactory.Companion, (OutputStream)outputStream, null, (int)2, null);
                    collection.encode((OutputStream)armorOut);
                    armorOut.close();
                } else {
                    collection.encode(outputStream);
                }
            }
        };
    }

    @NotNull
    public RevokeKey noArmor() {
        RevokeKeyImpl revokeKeyImpl;
        RevokeKeyImpl $this$noArmor_u24lambda_u242 = revokeKeyImpl = this;
        boolean bl = false;
        $this$noArmor_u24lambda_u242.armor = false;
        return revokeKeyImpl;
    }

    @NotNull
    public RevokeKey withKeyPassword(@NotNull byte[] password) {
        String string;
        RevokeKeyImpl revokeKeyImpl;
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        RevokeKeyImpl $this$withKeyPassword_u24lambda_u243 = revokeKeyImpl = this;
        boolean bl = false;
        try {
            string = UTF8Util.Companion.decodeUTF8(password);
        }
        catch (CharacterCodingException e) {
            throw new SOPGPException.PasswordNotHumanReadable("Cannot UTF8-decode password: " + ExceptionsKt.stackTraceToString((Throwable)e));
        }
        String string2 = string;
        $this$withKeyPassword_u24lambda_u243.protector.addPassphrase(Passphrase.Companion.fromPassword((CharSequence)string2));
        return revokeKeyImpl;
    }

    public static final /* synthetic */ boolean access$getArmor$p(RevokeKeyImpl $this) {
        return $this.armor;
    }
}

