/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.jctools.queues;

import monix.execution.internal.jctools.queues.MessagePassingQueue;
import monix.execution.internal.jctools.queues.MessagePassingQueueUtil;
import monix.execution.internal.jctools.queues.SpmcArrayQueueL3Pad;
import monix.execution.internal.jctools.util.UnsafeRefArrayAccess;

public class SpmcArrayQueue<E>
extends SpmcArrayQueueL3Pad<E> {
    public SpmcArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(currProducerIndex, mask);
        if (null != UnsafeRefArrayAccess.lvRefElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > mask) {
                return false;
            }
            while (null != UnsafeRefArrayAccess.lvRefElement(buffer, offset)) {
            }
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        this.soProducerIndex(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L));
        return (E)this.removeElement(this.buffer, currentConsumerIndex, this.mask);
    }

    private E removeElement(E[] buffer, long index, long mask) {
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(index, mask);
        E e = UnsafeRefArrayAccess.lpRefElement(buffer, offset);
        UnsafeRefArrayAccess.soRefElement(buffer, offset, null);
        return e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        long nextConsumerIndex = this.lvConsumerIndex();
        do {
            if ((currentConsumerIndex = nextConsumerIndex) >= currProducerIndexCache) {
                long currProducerIndex = this.lvProducerIndex();
                if (currentConsumerIndex >= currProducerIndex) {
                    return null;
                }
                currProducerIndexCache = currProducerIndex;
                this.svProducerIndexCache(currProducerIndex);
            }
            e = UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(currentConsumerIndex, mask));
            nextConsumerIndex = this.lvConsumerIndex();
        } while (null == e || nextConsumerIndex != currentConsumerIndex);
        return (E)e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
        if (null != UnsafeRefArrayAccess.lvRefElement(buffer, offset)) {
            return false;
        }
        UnsafeRefArrayAccess.soRefElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        Object e;
        long currentConsumerIndex;
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long nextConsumerIndex = this.lvConsumerIndex();
        do {
            currentConsumerIndex = nextConsumerIndex;
            e = UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(currentConsumerIndex, mask));
        } while ((nextConsumerIndex = this.lvConsumerIndex()) != currentConsumerIndex);
        return (E)e;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        int remaining;
        long currentConsumerIndex;
        if (null == c) {
            throw new IllegalArgumentException("c is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative: " + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        int adjustedLimit = 0;
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return 0;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + (long)(adjustedLimit = Math.min(remaining = (int)(currProducerIndexCache - currentConsumerIndex), limit))));
        for (int i = 0; i < adjustedLimit; ++i) {
            c.accept(this.removeElement(buffer, currentConsumerIndex + (long)i, mask));
        }
        return adjustedLimit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        if (null == s) {
            throw new IllegalArgumentException("supplier is null");
        }
        if (limit < 0) {
            throw new IllegalArgumentException("limit is negative:" + limit);
        }
        if (limit == 0) {
            return 0;
        }
        Object[] buffer = this.buffer;
        long mask = this.mask;
        long producerIndex = this.lpProducerIndex();
        for (int i = 0; i < limit; ++i) {
            long offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(producerIndex, mask);
            if (null != UnsafeRefArrayAccess.lvRefElement(buffer, offset)) {
                return i;
            }
            UnsafeRefArrayAccess.soRefElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
        return limit;
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return MessagePassingQueueUtil.drain(this, c);
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        MessagePassingQueueUtil.drain(this, c, w, exit);
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        MessagePassingQueueUtil.fill(this, s, w, e);
    }
}

