/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.zz6W;
import com.aspose.words.zzFn;
import com.aspose.words.zzGU;
import com.aspose.words.zzWEy;
import com.aspose.words.zzWUI;
import com.aspose.words.zzXL5;
import com.aspose.words.zzXRb;
import com.aspose.words.zzXab;
import com.aspose.words.zzXr2;
import com.aspose.words.zzZ9h;

public class Cell
extends CompositeNode<Node>
implements zzFn,
zzZ9h {
    private zzWUI zzWzt;
    private CellFormat zzWib;
    private ParagraphCollection zzZwT;
    private TableCollection zzVVW;

    public Cell(DocumentBase doc) {
        this(doc, new zzWUI());
    }

    Cell(DocumentBase doc, zzWUI cellPr) {
        super(doc);
        this.zzWzt = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzZLg();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzWXf();
    }

    public Row getParentRow() {
        return (Row)this.zzEs();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzVQJ() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYBq(this, true);
        }
        return -1;
    }

    final int zzRl() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzRl();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWib == null) {
            this.zzWib = new CellFormat(this);
        }
        return this.zzWib;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzZwT == null) {
            this.zzZwT = new ParagraphCollection(this);
        }
        return this.zzZwT;
    }

    public TableCollection getTables() {
        if (this.zzVVW == null) {
            this.zzVVW = new TableCollection(this);
        }
        return this.zzVVW;
    }

    final zzWUI zzXV6() {
        return this.zzWzt;
    }

    final void zzXkR(zzWUI zzWUI2) {
        this.zzWzt = zzWUI2;
    }

    @Override
    final Node zzXkR(boolean bl, zzXr2 zzXr22) {
        zzWUI zzWUI2;
        Cell cell = (Cell)super.zzXkR(bl, zzXr22);
        zzWUI zzWUI3 = this.zzWzt;
        cell.zzWzt = zzWUI2 = (zzWUI)zzWUI3.zzk2();
        cell.zzWib = null;
        cell.zzZwT = null;
        cell.zzVVW = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzWEy.zzYRu(this);
    }

    @Override
    final boolean zzz4(Node node) {
        return zzXab.zznt(node);
    }

    final int zzW1I() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWzt.zzXFw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzWzt.zzXFw(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zz6W zz6W2 = zzZGD.zzXkR(object, zz6W.class);
        if (zz6W2 != null && zz6W2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzXFW(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzWUI.zzZr5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzWzt.zzWpi(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWzt.clear();
    }

    private Object zzXFW(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZGD.zzXkR((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXkR(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXRb getInsertRevision() {
        Cell cell = this;
        return cell.zzWzt.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXRb value) {
        Cloneable cloneable = this;
        zzXRb zzXRb2 = value;
        cloneable = cloneable.zzWzt;
        ((zzGU)cloneable).zzWpi(14, zzXRb2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXRb getDeleteRevision() {
        Cell cell = this;
        return cell.zzWzt.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXRb value) {
        Cloneable cloneable = this;
        zzXRb zzXRb2 = value;
        cloneable = cloneable.zzWzt;
        ((zzGU)cloneable).zzWpi(12, zzXRb2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXL5 getMoveFromRevision() {
        Cell cell = this;
        return cell.zzWzt.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzXL5 value) {
        Cloneable cloneable = this;
        zzXL5 zzXL52 = value;
        cloneable = cloneable.zzWzt;
        ((zzGU)cloneable).zzWpi(13, zzXL52);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXL5 getMoveToRevision() {
        Cell cell = this;
        return cell.zzWzt.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzXL5 value) {
        Cloneable cloneable = this;
        zzXL5 zzXL52 = value;
        cloneable = cloneable.zzWzt;
        ((zzGU)cloneable).zzWpi(15, zzXL52);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzWzt.remove(13);
        cell = this;
        cell.zzWzt.remove(15);
    }

    final zzWUI zzZRF(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzWUI zzWUI2 = new zzWUI();
        this.zzXkR(3120, zzWUI2);
        this.zzXkR(3140, zzWUI2);
        this.zzXkR(3110, zzWUI2);
        this.zzXkR(3130, zzWUI2);
        this.zzXkR(3090, zzWUI2);
        this.zzXkR(3100, zzWUI2);
        this.zzXkR(3070, zzWUI2);
        this.zzXkR(3080, zzWUI2);
        if (bl && (tableStyle = zzZGD.zzXkR((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYRr(this, zzWUI2);
        }
        this.zzWzt.zzYRr((zzGU)zzWUI2);
        return zzWUI2;
    }

    private void zzXkR(int n, zzWUI zzWUI2) {
        zzWUI2.zzWpi(n, this.fetchInheritedCellAttr(n));
    }
}

