/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzZBy;
import com.aspose.words.zzJX;
import com.aspose.words.zzL2;
import com.aspose.words.zzVPT;
import com.aspose.words.zzWhP;
import com.aspose.words.zzWzp;
import com.aspose.words.zzYIy;
import com.aspose.words.zzYd5;
import com.aspose.words.zzYyb;
import com.aspose.words.zzZr5;
import com.aspose.words.zzbB;
import com.aspose.words.zzv0;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzYyb zzWpJ;

    ChartSeriesCollection(zzYyb chartSpace) {
        this.zzWpJ = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zznK().zzWsp().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zznK().zzWsp().iterator();
    }

    public void removeAt(int index) {
        this.zznK().zzZr3(index);
    }

    public void clear() {
        this.zznK().zzZzz();
        for (zzYIy zzYIy2 : this.zzWpJ.zzZWh()) {
            zzYIy2.zzWhJ(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXkR(chartSeriesCollection.zznK().zzWCL(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXkR(chartSeriesCollection.zznK().zzWCL(), seriesName, xValues, yValues);
    }

    private ChartSeries zzXkR(String string, zzZBy[] zzZByArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXkR(chartSeriesCollection.zznK().zzWCL(), string, zzZByArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXkR(seriesName, zzZBy.zzXkR(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzXkR(chartSeriesCollection.zznK().zzWCL(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzXkR(zzYIy zzYIy2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXkR(zzYIy2, string, dArray);
        chartSeries.zzZdR().zzZIr(ChartSeriesCollection.zzrY(stringArray));
        return chartSeries;
    }

    final ChartSeries zzXkR(zzYIy zzYIy2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXkR(zzYIy2, string, dArray2);
        chartSeries.zzZdR().zzZIr(ChartSeriesCollection.zzz4(dArray));
        return chartSeries;
    }

    private ChartSeries zzXkR(zzYIy zzYIy2, String string, zzZBy[] zzZByArray, double[] dArray) {
        if (zzZByArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzZByArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzZByArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXkR(zzYIy2, string, dArray);
        chartSeries.zzZdR().zzZIr(ChartSeriesCollection.zzXkR(zzZByArray));
        if (!zzYIy2.zzWFT()) {
            zzYIy2.zzWhJ(true);
        }
        return chartSeries;
    }

    final ChartSeries zzXkR(zzYIy zzYIy2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzYIy2.zzXCG() != 15) {
            zzYIy2.zzdC(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXkR(zzYIy2, string, dArray2);
        chartSeries.zzVQs().zzWNc().zzWCa(3, chartSeries.zzXwB().zzY89());
        chartSeries.zzZdR().zzZIr(ChartSeriesCollection.zzz4(dArray));
        if (dArray3 != null) {
            chartSeries.zzVQP().zzZIr(ChartSeriesCollection.zzz4(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzXkR(zzYIy zzYIy2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzYIy2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzYdB(chartSeries);
        chartSeries.zzU7().zzZIr(ChartSeriesCollection.zzz4(dArray));
        this.zzWpJ.zzZdk();
        this.zznK().zzYTI(chartSeries);
        return chartSeries;
    }

    private static void zzYdB(ChartSeries chartSeries) {
        chartSeries.zzVQs().zzWNc().zzWCa(5, new zzVPT());
        if (ChartDataPointCollection.zzWSe(chartSeries.zzXwB().zzXCG())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzXwB().zzXCG()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXkR(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXkR(chartSeries, 5);
                ChartSeriesCollection.zzZFh(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXkR(chartSeries, 1);
                ChartSeriesCollection.zzZFh(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzWpi(chartSeries);
            }
        }
    }

    private static void zzWpi(ChartSeries chartSeries) {
        zzVPT zzVPT2 = new zzVPT();
        zzVPT2.setOutline(new zzv0());
        zzWzp zzWzp2 = new zzWzp();
        zzWzp2.zzZwz(1);
        zzVPT2.getOutline().setFill(new zzJX(zzWzp2));
        zzVPT2.getOutline().zz4h(19050.0);
        chartSeries.zzVQs().zzWNc().zzWCa(5, zzVPT2);
    }

    private static void zzZFh(ChartSeries chartSeries) {
        zzVPT zzVPT2 = new zzVPT();
        zzVPT2.setOutline(new zzv0());
        zzVPT2.getOutline().setFill(new zzbB());
        zzVPT2.getOutline().setEndCap(0);
        zzVPT2.getOutline().zz4h(19050.0);
        chartSeries.zzVQs().zzWNc().zzWCa(5, zzVPT2);
    }

    private static void zzXkR(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzXwB());
        chartMarker.zzXO4().zzWCa(0, n);
        chartSeries.zzVQs().zzWNc().zzWCa(4, chartMarker);
    }

    private static zzYd5 zzz4(double[] dArray) {
        int n = 0;
        zzYd5 zzYd52 = new zzYd5(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzYd52.zzZZK(new zzZr5(n, d, "General"));
            }
            ++n;
        }
        zzYd52.zzWQo(dArray.length);
        return zzYd52;
    }

    private static zzYd5 zzXkR(zzZBy[] zzZByArray) {
        int n = 0;
        zzYd5 zzYd52 = new zzYd5(2);
        zzZBy[] zzZByArray2 = zzZByArray;
        int n2 = zzZByArray.length;
        for (int i = 0; i < n2; ++i) {
            zzZBy zzZBy2 = zzZByArray2[i];
            zzYd52.zzZZK(new zzZr5(n++, zzZBy2.zzZKp(), "m/d/yyyy"));
        }
        zzYd52.zzWQo(zzZByArray.length);
        return zzYd52;
    }

    private static zzYd5 zzrY(String[] stringArray) {
        int n = 0;
        zzYd5 zzYd52 = new zzYd5(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzYd52.zzZZK(new zzL2(n++, string));
        }
        zzYd52.zzWQo(stringArray.length);
        return zzYd52;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zznK().zzWsp().size();
    }

    private zzWhP zznK() {
        return this.zzWpJ.zzVZB().zznK();
    }
}

