/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWTW;
import com.aspose.words.internal.zzZBy;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.zz4h;
import com.aspose.words.zzWW;
import com.aspose.words.zzXL5;
import com.aspose.words.zzXeu;
import com.aspose.words.zzY0d;
import com.aspose.words.zzZ4x;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzWW,
zzZ4x {
    private int zzvn;
    private boolean zzYD0;
    private boolean zzgs;
    private int zzWfv;
    private int zzYbi = -1;
    private String zzXss = "";
    private String zzVUq = "";
    private zzZBy zzXCg = zzZBy.zzYcR;
    private zzZBy zzY5E = zzZBy.zzYcR;
    private CommentCollection zzYqJ;

    Comment(DocumentBase doc, zzY0d runPr) {
        super(doc, runPr);
        this.zzWfv = doc.zzZpj();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzZBy.zzYcR);
    }

    private Comment(DocumentBase doc, String author, String initial, zzZBy dateTime) {
        this(doc, new zzY0d());
        this.setAuthor(author);
        this.setInitial(initial);
        zzZBy zzZBy2 = dateTime;
        Comment comment = this;
        this.zzXCg = zzZBy2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzZBy.zzXkR(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzWfv;
    }

    public final void setId(int value) {
        this.zzWfv = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWxM();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzXss;
    }

    public final void setInitial(String value) {
        zzZGD.zzYRr((Object)value, "Initial");
        this.zzXss = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzZBy.zzW3e(comment.zzXCg);
    }

    private void zz5o(zzZBy zzZBy2) {
        this.zzXCg = zzZBy2;
        if (!zzZBy.zzXkR(this.zzY5E, zzZBy.zzYcR)) {
            this.zzY5E = !zzZBy.zzXkR(zzZBy2, zzZBy.zzYcR) ? zzZBy2.zzeg() : zzZBy.zzYcR;
        }
    }

    public final void setDateTime(Date value) {
        this.zz5o(zzZBy.zzXkR(value));
    }

    final zzZBy zzZu2() {
        return this.zzXCg;
    }

    final void zzWCG(zzZBy zzZBy2) {
        this.zzXCg = zzZBy2;
    }

    final zzZBy zzb() {
        return this.zzY5E;
    }

    final void zzWOV(zzZBy zzZBy2) {
        this.zzY5E = zzZBy2;
    }

    public final String getAuthor() {
        return this.zzVUq;
    }

    public final void setAuthor(String value) {
        zzZGD.zzYRr((Object)value, "Author");
        this.zzVUq = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzXkR(String string, String string2, zzZBy zzZBy2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzZBy2);
        comment.setIdInternal(zz4h.zzXkR(this.getDocument()));
        comment.setParentId(this.zzWfv);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzZGD.zzXkR((Object)this.zzvT(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzWfv) {
            comment2 = comment3;
            comment3 = zzZGD.zzXkR((Object)comment3.zzvT(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzXeu zzXeu2 = new zzXeu();
        if (zzXeu2.zzYRr(this.getDocument(), this.zzWfv)) {
            this.zzXkR(zzXeu2.zzY6t(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzXkR(zzXeu2.zzYxk(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzXkR(author, initial, zzZBy.zzXkR(dateTime), text);
    }

    private void zzXkR(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzWTW.zzXkR(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeStart2, (Node)object);
    }

    private void zzXkR(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzWTW.zzXkR(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzWfv) break;
            object = node;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeEnd2, (Node)object);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzXeu zzXeu2 = new zzXeu();
        if (zzXeu2.zzYRr(this.getDocument(), reply.getId())) {
            zzXeu2.zzY6t().remove();
            zzXeu2.zzYxk().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzF7()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzXws());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzXws(), '\u0005', new zzY0d());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzYqJ == null) {
            this.zzYqJ = new CommentCollection(this.getDocument(), this);
        }
        return this.zzYqJ;
    }

    public final boolean getDone() {
        return this.zzgs;
    }

    public final void setDone(boolean value) {
        this.zzgs = value;
    }

    public final int getParentId() {
        return this.zzYbi;
    }

    public final void setParentId(int value) {
        this.zzYbi = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWxM();
        }
    }

    final int zzYp() {
        return this.zzvn;
    }

    final void zzXs6(int n) {
        this.zzvn = n;
    }

    final boolean zzYYG() {
        return this.zzYD0;
    }

    final void zzXeu(boolean bl) {
        this.zzYD0 = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXL5 getMoveFromRevision() {
        return this.zzZs6().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzXL5 value) {
        zzXL5 zzXL52 = value;
        zzY0d zzY0d2 = this.zzZs6();
        zzY0d2.zzWpi(13, zzXL52);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzXL5 getMoveToRevision() {
        return this.zzZs6().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzXL5 value) {
        zzXL5 zzXL52 = value;
        zzY0d zzY0d2 = this.zzZs6();
        zzY0d2.zzWpi(15, zzXL52);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzZs6().remove(13);
        this.zzZs6().remove(15);
    }

    final String zzyA() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzOQ(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

