/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz6f;
import com.aspose.words.internal.zzRl;
import com.aspose.words.internal.zzXff;
import com.aspose.words.internal.zzYOa;
import com.aspose.words.internal.zzYXU;
import com.aspose.words.internal.zzYYT;
import com.aspose.words.internal.zzZ29;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.internal.zzZSK;
import com.aspose.words.internal.zzZXK;
import com.aspose.words.internal.zzcC;
import com.aspose.words.internal.zzlj;
import com.aspose.words.zz8R;
import com.aspose.words.zzVQ3;
import com.aspose.words.zzVXS;
import com.aspose.words.zzW7b;
import com.aspose.words.zzWMc;
import com.aspose.words.zzXQ3;
import com.aspose.words.zzXTA;
import com.aspose.words.zzXod;
import com.aspose.words.zzXr6;
import com.aspose.words.zzZDv;
import com.aspose.words.zzZPv;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXkR(zzlj zzlj2, zzlj zzlj3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZGD.zzYRr((Object)zzlj2, "srcStream");
        zzZGD.zzYRr((Object)zzlj3, "dstStream");
        zzZGD.zzYRr((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYRr(zzlj2, zzlj3, certificateHolder, signOptions);
        zzlj3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXkR(zzlj.zzYRr(srcStream), (zzlj)zzlj.zzZJO(dstStream), certHolder, signOptions);
    }

    private static void zzYRr(zzlj zzlj2, zzlj zzlj3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzZJO(digitalSignature);
        }
        if (zzXod.zzWb9(zzlj2)) {
            DigitalSignatureUtil.zzXkR(zzlj2, zzlj3, digitalSignature, true);
            return;
        }
        zzXod zzXod2 = new zzXod();
        zzlj zzlj4 = zzlj2;
        zzXod zzXod3 = zzXod2;
        FileFormatInfo fileFormatInfo = zzXod2.zzYRr(zzlj4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYYT zzYYT2 = new zzYYT(zzlj2);
                int n = fileFormatInfo.zzZJT() == 1 ? 1 : 2;
                zzVXS.zzXkR(zzYYT2, digitalSignature, n);
                zzlj3.zzZsw(0L);
                zzYYT2.zzYTI(zzlj3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXkR(fileFormatInfo.zzXPd(), zzlj3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXkR(zzlj2, zzlj3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzXkR(zzlj2, zzlj3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZGD.zzZJO(srcFileName, "srcFileName");
        zzZGD.zzZJO(dstFileName, "dstFileName");
        try (zz6f zz6f2 = zzZGD.zzYRr(srcFileName, 3, 1);){
            try (zz6f zz6f3 = zzZGD.zzYRr(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXkR((zzlj)zz6f2, (zzlj)zz6f3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZXK zzZXK2 = zzlj.zzZJO(dstStream);
        zzlj zzlj2 = zzlj.zzYRr(srcStream);
        DigitalSignatureUtil.zzXkR(zzlj2, (zzlj)zzZXK2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zz6f zz6f2 = zzZGD.zzYRr(srcFileName, 3, 1);){
            try (zz6f zz6f3 = zzZGD.zzYRr(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzZIr(zz6f2, zz6f3);
            }
            return;
        }
    }

    private static void zzZIr(zzlj zzlj2, zzlj zzlj3) throws Exception {
        zzXod zzXod2 = new zzXod();
        zzlj zzlj4 = zzlj2;
        Object object = zzXod2;
        FileFormatInfo fileFormatInfo = zzXod2.zzYRr(zzlj4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYYT zzYYT2 = new zzYYT(zzlj2);
                zzYYT2.zzWwv().zzVPK("_xmlsignatures");
                zzYYT2.zzWwv().zzVPK("_signatures");
                zzlj3.zzW1f(0L);
                zzYYT2.zzYTI(zzlj3);
                zzlj zzlj5 = zzlj3;
                zzlj5.zzZsw(zzlj5.zzYSS());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzZSK zzZSK2 = new zzZSK(zzlj2);
                zzXff zzXff2 = zzZSK2.zzXkR(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzXff2 != null) {
                    for (zzcC zzcC2 : zzXff2.zzWqZ()) {
                        String string = zzXff2.zzXkR(zzcC2);
                        zzZSK2.zzZqk().remove(string);
                    }
                    zzZSK2.zzZqk().remove(zzXff2.getName());
                    zzcC zzcC3 = zzZSK2.zzWqZ().zzWA0("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzZSK2.zzWqZ().remove(zzcC3.getId());
                    zzZSK2.zzZa8();
                }
                zzlj3.zzW1f(0L);
                zzZSK2.zzYTI(zzlj3);
                zzlj zzlj6 = zzlj3;
                zzlj6.zzZsw(zzlj6.zzYSS());
                return;
            }
            case 60: 
            case 61: {
                zzXr6 zzXr62 = new zzXr6(zzlj2);
                zz8R zz8R2 = zzXr62.zzDA("/META-INF/documentsignatures.xml");
                if (zz8R2 != null) {
                    zzXr62.zzYJI().remove(zz8R2.getName());
                }
                zzlj3.zzW1f(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzlj4 = zzlj3;
                object = zzXr62;
                ((zzXr6)object).zzXkR(zzlj4, string, null);
                zzlj zzlj7 = zzlj3;
                zzlj7.zzZsw(zzlj7.zzYSS());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzZIr(zzlj.zzYRr(srcStream), zzlj.zzZJO(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zz6f zz6f2 = zzZGD.zzYRr(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzY8a(zz6f2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzY8a(zzlj zzlj2) throws Exception {
        if (zzXod.zzWb9(zzlj2)) {
            return DigitalSignatureUtil.zzWqd(zzlj2);
        }
        zzXod zzXod2 = new zzXod();
        zzlj zzlj3 = zzlj2;
        zzXod zzXod3 = zzXod2;
        FileFormatInfo fileFormatInfo = zzXod2.zzYRr(zzlj3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzlj2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzY8a(zzlj.zzYRr(stream));
    }

    static zzYOa zzXkR(zzYYT zzYYT2, String string) throws Exception {
        zzXTA zzXTA2 = new zzXTA(zzYYT2);
        if (zzXTA2.zzWuc()) {
            zzYOa zzYOa2 = zzXTA2.zzWDX(string);
            return zzYOa2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzYjQ(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzZ29.zzYRr("Unexpected digest algorithm: {0}.", n));
    }

    static String zzYXq(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzYjQ(n);
    }

    private static void zzXkR(zzlj zzlj2, zzlj zzlj3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzZSK zzZSK2 = new zzZSK(zzlj2);
        zzVQ3 zzVQ32 = bl ? new zzZPv(zzZSK2) : new zzZDv(zzZSK2);
        zzVQ32.zzYRr(digitalSignature);
        zzlj3.zzZsw(0L);
        zzZSK2.zzYTI(zzlj3);
    }

    private static void zzXkR(zzlj zzlj2, zzlj zzlj3, DigitalSignature digitalSignature) throws Exception {
        zzXr6 zzXr62 = new zzXr6(zzlj2);
        zzW7b zzW7b2 = new zzW7b(zzXr62);
        zzW7b2.zzYRr(digitalSignature);
        zzlj3.zzZsw(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzlj zzlj4 = zzlj3;
        zzXr6 zzXr63 = zzXr62;
        zzXr63.zzXkR(zzlj4, string, null);
    }

    private static void zzXkR(zzYYT zzYYT2, zzlj zzlj2, DigitalSignature digitalSignature, String string) throws Exception {
        zzYOa zzYOa2 = DigitalSignatureUtil.zzXkR(zzYYT2, string);
        zzYOa zzYOa3 = new zzYOa();
        DigitalSignatureUtil.zzXkR((zzlj)zzYOa2, (zzlj)zzYOa3, digitalSignature, false);
        zzYYT zzYYT3 = zzXTA.zzZIr(zzYOa3, string);
        zzYYT3.zzYTI(zzlj2);
    }

    private static DigitalSignatureCollection zzWqd(zzlj zzlj2) throws Exception {
        zzlj2.zzW1f(0L);
        zzZSK zzZSK2 = new zzZSK(zzlj2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzXff zzXff2 = zzZSK2.zzXkR(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzXff2 != null) {
            for (zzcC zzcC2 : zzXff2.zzWqZ()) {
                String string = zzXff2.zzXkR(zzcC2);
                zzXff zzXff3 = zzZSK2.zzWkS(string);
                zzXff zzXff4 = zzZSK2.zzXkR(zzXff3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzYXU zzYXU2 = zzRl.zzZt0(zzXff4.zzYDM().zzYUm());
                zzXQ3.zzXkR(zzXff3.zzZOr(), zzYXU2, new zzWMc(zzZSK2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

