/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXHZ;
import com.aspose.words.internal.zzZ29;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWNU;
import com.aspose.words.zzXab;
import com.aspose.words.zzXr2;
import com.aspose.words.zzZ4x;
import com.aspose.words.zzoV;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzXeJ;
    private Node zzWrJ;
    private Node zzXOv;
    private int zzjl;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzZJO(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXeJ == null) {
            return null;
        }
        if (this.zzXeJ.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzXeJ;
    }

    final CompositeNode zzEs() {
        if (zzXab.zzWoP(this.getParentNode())) {
            return this.getParentNode().zzEs();
        }
        return this.getParentNode();
    }

    final CompositeNode zzYIk() {
        if (zzXab.zzWoP(this.getParentNode()) || zzXab.zzXNh(this.getParentNode())) {
            return this.getParentNode().zzYIk();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzXeJ != null) {
            return this.zzXeJ.getDocument();
        }
        return null;
    }

    final Document zzXws() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZiJ() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzag();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXOv;
    }

    final Node zzXzR() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzXab.zzgC((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzVZt() {
        Node node = zzXab.zzYdB(this.getPreviousSibling(), false);
        if (node == null && zzXab.zzWoP(this.getParentNode())) {
            node = this.getParentNode().zzVZt();
        }
        return node;
    }

    final Node zzCU() {
        Node node = zzXab.zzZZK(this.getNextSibling(), false);
        if (node == null && zzXab.zzWoP(this.getParentNode())) {
            node = this.getParentNode().zzCU();
        }
        return node;
    }

    final CompositeNode zzWXf() {
        Node node = this;
        while ((node = node.zzVZt()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzZLg() {
        Node node = this;
        while ((node = node.zzCU()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzWrJ;
    }

    final Node zzvT() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzXab.zzgC((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZax() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zz69() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zz0G() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXab.zzZYX(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzpy() {
        return this.zzWrJ;
    }

    final void zzYnw(Node node) {
        this.zzWrJ = node;
    }

    final Node zzXS9() {
        return this.zzXOv;
    }

    final void zzYt1(Node node) {
        this.zzXOv = node;
    }

    final Node zzY4e() {
        Node node = this;
        if (node.zzWrJ != null) {
            node = this;
            return node.zzWrJ;
        }
        return this.getParentNode();
    }

    final int zzVQ0() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXab.zzYah(this);
        boolean bl2 = zzXab.zznt(this);
        boolean bl3 = zzXab.zzFT(this);
        boolean bl4 = zzXab.zzVWG(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzVQ0() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzVQ0() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXkR(isCloneChildren, new zzXkR(this));
    }

    Node zzXkR(boolean bl, zzXr2 zzXr22) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXeJ != null) {
            node.zzXeJ = this.getDocument().zzVPn();
        }
        node.zzWrJ = null;
        node.zzXOv = null;
        if (zzXr22 != null) {
            zzXr22.zzYBq(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzOQ(StringBuilder stringBuilder) {
        zzZGD.zzYRr(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzWp2(Node node) {
        this.zzXeJ = node != null ? node : this.getDocument().zzVPn();
    }

    final void zzZJO(DocumentBase documentBase) {
        this.zzXeJ = documentBase != null ? documentBase.zzVPn() : null;
    }

    final boolean zzWlx(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzXZc() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzYMG(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzUA(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzWCa(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzOQ(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzXUf(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzWNU zzWNU2 = zzXab.zzxw(saveFormat);
        return zzWNU2.zzWvp(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzWNU zzWNU2 = zzXab.zzYRr(saveOptions);
        return zzWNU2.zzWvp(this);
    }

    final Node zzZzr(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXab.zzZi5(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzoV zzXEZ() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzoV.zzVVZ(node);
        }
        return zzoV.zzWOV(this.getParentNode());
    }

    final zzoV zzXPn() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzoV.zzWOV(node);
        }
        return zzoV.zzVVZ(this.getParentNode());
    }

    final boolean zzZF8(Node node) {
        return Node.zzWCG(this, node);
    }

    final boolean zzWYE() {
        return this.getAncestor(1) == null;
    }

    static Node zz5o(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzXHZ<Node> zzXHZ2 = Node.zzXnT(node);
        zzXHZ<Node> zzXHZ3 = Node.zzXnT(node2);
        return Node.zzXkR(zzXHZ2, zzXHZ3);
    }

    static boolean zzWCG(Node node, Node node2) {
        zzXHZ<Node> zzXHZ2;
        if (node == null || node2 == null) {
            return false;
        }
        zzXHZ<Node> zzXHZ3 = Node.zzXnT(node);
        Node node3 = Node.zzXkR(zzXHZ3, zzXHZ2 = Node.zzXnT(node2));
        if (node3 == null) {
            return false;
        }
        zzXHZ<Node> zzXHZ4 = zzXHZ3;
        if (zzXHZ4.size() == 0 || (zzXHZ4 = zzXHZ2).size() == 0) {
            zzXHZ4 = zzXHZ2;
            boolean bl = zzXHZ4.size() > 0;
            return bl;
        }
        Object e = zzXHZ3.peek();
        Object e2 = zzXHZ2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzXHZ<Node> zzXnT(Node node) {
        zzXHZ<Node> zzXHZ2 = new zzXHZ<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzXHZ2.push(node2);
        }
        return zzXHZ2;
    }

    private static Node zzXkR(zzXHZ<Node> zzXHZ2, zzXHZ<Node> zzXHZ3) {
        Node node = null;
        while (zzXHZ2.peek() == zzXHZ3.peek()) {
            node = (Node)zzXHZ2.pop();
            zzXHZ3.pop();
            zzXHZ<Node> zzXHZ4 = zzXHZ2;
            if (zzXHZ4.size() != 0 && (zzXHZ4 = zzXHZ3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzjl;
    }

    public void setCustomNodeId(int value) {
        this.zzjl = value;
    }

    private String zzZ0e() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzZGD.zzXkR(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzZ29.zzXMp(stringBuilder.toString());
    }

    public String toString() {
        return zzZ29.zzXMp(zzZ29.zzYRr("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzZ0e()));
    }

    public void dd() {
    }

    final Node zzFT(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzRg(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYah(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzRg(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzRg(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzXkR
    implements zzXr2 {
        private Node zzYCs;
        private HashMap<Integer, Integer> zzWHb;

        zzXkR(Node node) {
            this.zzYCs = node;
        }

        @Override
        public final void zzYBq(Node node, Node node2) {
            if (node == this.zzYCs) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzZ4x zzZ4x2 = (zzZ4x)((Object)node2);
            if (this.zzWHb == null) {
                this.zzWHb = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZGD.zzXkR(this.zzWHb, Integer.valueOf(zzZ4x2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZpj();
                zzZGD.zzYRr(this.zzWHb, Integer.valueOf(zzZ4x2.getIdInternal()), Integer.valueOf(n));
            }
            zzZ4x2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZGD.zzXkR(this.zzWHb, Integer.valueOf(zzZ4x2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzZ4x2.setParentIdInternal(n2);
            }
        }
    }
}

