/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzZ29;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.zzWL2;
import com.aspose.words.zzXr2;
import com.aspose.words.zzZpM;

public final class Section
extends CompositeNode<Node>
implements zzZpM {
    private zzWL2 zzZOS;
    private PageSetup zzYxv;
    private HeaderFooterCollection zzX7e;

    public Section(DocumentBase doc) {
        this(doc, new zzWL2());
    }

    Section(DocumentBase doc, zzWL2 sectPr) {
        super(doc);
        this.zzZOS = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zzX7e == null) {
            this.zzX7e = new HeaderFooterCollection(this);
        }
        return this.zzX7e;
    }

    public final PageSetup getPageSetup() {
        if (this.zzYxv == null) {
            Section section = this;
            this.zzYxv = new PageSetup(section, section.getDocument().zzXT1(), this.getDocument().getStyles(), new zzXkR(this));
        }
        return this.zzYxv;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzZw4();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzZJi(!value);
    }

    final zzWL2 zzVW1() {
        return this.zzZOS;
    }

    final void zzYRr(zzWL2 zzWL22) {
        this.zzZOS = zzWL22;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzXkR(boolean bl, zzXr2 zzXr22) {
        zzWL2 zzWL22;
        Section section = (Section)super.zzXkR(bl, zzXr22);
        zzWL2 zzWL23 = this.zzZOS;
        section.zzZOS = zzWL22 = (zzWL2)zzWL23.zzk2();
        section.zzYxv = null;
        section.zzX7e = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzYBq(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzYBq(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).removeAllChildren();
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final Story zzTI(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzz4(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzTI(n) == null;
            }
        }
        return false;
    }

    final void zzZJO(Shape shape, boolean bl) throws Exception {
        this.zzXkR(shape, 4, bl);
        this.zzXkR(shape, 0, bl);
        this.zzXkR(shape, 1, bl);
    }

    private void zzXkR(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzWy7());
        shape2.setName(zzZ29.zzYRr("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzXdw() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZLB()) {
                if (!shape.zzYnp()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzYBq(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYRr(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzZOS.zzXFw(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zzXT1().zzYyX.zzYBp(key);
        }
        return zzWL2.zzZr5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzZOS.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zzXT1().zzYyX.zzWpi(key, value);
            return;
        }
        this.zzZOS.zzWpi(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzZOS.clear();
    }

    final boolean zzYxT() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzWah() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzZOS.getSectionStart());
        return zzZ29.zzYRr("{0} {1}", objectArray);
    }

    static final class zzXkR
    implements zzZpM {
        private Section zzWwJ;

        zzXkR(Section section) {
            this.zzWwJ = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzXf8().getDirectSectionAttr(key);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzXf8().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzXf8().fetchSectionAttr(key);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzZpM zzXf8() {
            Document document = zzZGD.zzXkR((Object)this.zzWwJ.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzWwJ;
        }
    }
}

