/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zz5W;
import com.aspose.words.internal.zzYaE;
import com.aspose.words.internal.zzZ29;
import com.aspose.words.internal.zzZGD;
import com.aspose.words.internal.zzZVt;
import com.aspose.words.internal.zzbD;
import com.aspose.words.zzZJw;
import java.awt.image.BufferedImage;

public final class Watermark {
    private Document zzXaG;
    private zzZJw zzWW4;

    Watermark(Document doc, zzZJw watermarkProvider) {
        this.zzXaG = doc;
        this.zzWW4 = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZVt(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzXkR(text, textWatermarkOptions, this.zzXaG);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzZGD.zzYRr((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzXaG, 75);
        shape.getImageData().setImage(image);
        this.zzXkR(shape, options, this.zzXaG);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzZGD.zzYRr((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzXaG, 75);
        shape.getImageData().setImage(imagePath);
        this.zzXkR(shape, options, this.zzXaG);
    }

    public final int getType() {
        Shape shape = this.zzWW4.get();
        if (shape == null) {
            return 2;
        }
        shape.zzYnp();
        if (shape.zzYY4()) {
            return 0;
        }
        if (shape.zzUL()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzWW4.add(shape);
    }

    public final void remove() {
        this.zzWW4.remove();
    }

    private static void zzZVt(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzYaE.zzW1L(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzZGD.zzXkR(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzXkR(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYRr(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzZIr(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYRr(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzYo5() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zz7X()) / d2) > (double)(f = pageSetup.zzZgT())) {
            d = (double)f / d3;
        }
        shape.zzOK(zzbD.zzZJO(d2 * d, 2, 1));
        shape.zzYjP(zzbD.zzZJO(d3 * d, 2, 1));
    }

    private Shape zzXkR(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzXkR(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzZIr(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzXkR(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYSD() ? 1.0f : textWatermarkOptions.getFontSize();
        zz5W zz5W2 = document.zzZ1u().zzZJO(shape.getTextPath().getFontFamily(), f, 0);
        long l = zz5W2.zzRg(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYSD()) {
            l = Watermark.zzXkR(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzOK(zzbD.zzZJO(Float.intBitsToFloat(n), 2, 1));
        shape.zzYjP(zzbD.zzZJO(zzZVt.zzWjJ(l), 2, 1));
    }

    private static long zzXkR(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zz7X();
        float f2 = pageSetup.zzZgT();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzZVt.zzWjJ(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzZVt.zzZsw(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzZVt.zzWjJ(l) >= Float.intBitsToFloat(n)) {
            return zzZVt.zzZsw(f2 / f3, f2);
        }
        float f6 = f;
        return zzZVt.zzZsw(f6, f6 * f3);
    }

    private static void zzZIr(Shape shape, String string) {
        shape.setName(zzZ29.zzYRr("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

