/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzZ29;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzX4d = new ArrayList();
    private final Map<String, DataColumn> zzWNA = new HashMap<String, DataColumn>();
    private DataTable zzZYO;

    DataColumnCollection(DataTable table) {
        this.zzZYO = table;
    }

    public void add(DataColumn column) {
        if (zzZ29.zzQQ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzVSw(column.getColumnName());
        if (this.zzWNA.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYBq(this.zzZYO);
        column.setOrdinal(this.zzX4d.size());
        this.zzX4d.add(column);
        this.zzWNA.put(string, column);
        this.zzZYO.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZYO);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZYO);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzZ29.zzQQ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzVSw(columnName);
        DataColumn dataColumn = this.zzWNA.get(string);
        if (dataColumn != null) {
            int n = this.zzX4d.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzX4d.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzX4d.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzX4d.remove(n);
            this.zzWNA.remove(DataColumnCollection.zzVSw(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZYO.getRows()) {
                dataRow.remove(n);
            }
            this.zzZYO.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzX4d.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzX4d.iterator();
    }

    public void clear() {
        this.zzWNA.clear();
        this.zzX4d.clear();
    }

    final DataColumn[] zzXq3() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzX4d);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzXkR(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzX4d.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzX4d.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzVSw(string);
            String string3 = DataColumnCollection.zzVSw(dataColumn.getColumnName());
            this.zzWNA.remove(string3);
            this.zzWNA.put(string2, dataColumn);
            return;
        }
    }

    private static String zzVSw(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

