/*
 * Decompiled with CFR 0.152.
 */
package ambience.gitdeploy;

import ambience.gitdeploy.BranchesAndTags;
import ambience.gitdeploy.BranchesAndTags$;
import ambience.gitdeploy.GitLogic;
import ambience.gitdeploy.GitLogic$Branch$;
import ambience.gitdeploy.GitLogic$Tag$;
import ambience.gitdeploy.IdLogger$;
import ambience.gitdeploy.PLogger;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GitLogic$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitLogic$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final GitLogic$Branch$ Branch;
    public static final GitLogic$Tag$ Tag;
    public static final GitLogic$ MODULE$;

    private GitLogic$() {
    }

    static {
        MODULE$ = new GitLogic$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitLogic$.class);
    }

    public BranchesAndTags branchAndTagNames(String repository) {
        BranchesAndTags branchesAndTags2;
        this.log().info(() -> this.branchAndTagNames$$anonfun$1(repository), Line$.MODULE$.apply(19), FullName$.MODULE$.apply("ambience.gitdeploy.GitLogic.branchAndTagNames"));
        try {
            List all = Process$.MODULE$.apply("git ls-remote " + repository).lazyLines().toList();
            this.log().info(() -> this.branchAndTagNames$$anonfun$2(all), Line$.MODULE$.apply(22), FullName$.MODULE$.apply("ambience.gitdeploy.GitLogic.branchAndTagNames"));
            BranchesAndTags ret = (BranchesAndTags)all.foldLeft((Object)BranchesAndTags$.MODULE$.apply(repository, (List)package$.MODULE$.Nil(), (List)package$.MODULE$.Nil()), (Function2 & Serializable)(branchesAndTags, line) -> this.buildBranchesAndTags((BranchesAndTags)branchesAndTags, (String)line));
            List list = (List)ret.branches().sorted((Ordering)Ordering.String$.MODULE$);
            List list2 = ((List)ret.tags().sorted((Ordering)Ordering.String$.MODULE$)).filterNot((Function1 & Serializable)elem -> ret.branches().contains(elem));
            String string = ret.copy$default$1();
            branchesAndTags2 = ret.copy(string, list, list2);
        }
        catch (Throwable ex) {
            this.log().error(() -> this.branchAndTagNames$$anonfun$3(repository, ex), Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.gitdeploy.GitLogic.branchAndTagNames"));
            branchesAndTags2 = BranchesAndTags$.MODULE$.apply(repository, (List)package$.MODULE$.Nil(), (List)package$.MODULE$.Nil());
        }
        return branchesAndTags2;
    }

    public BranchesAndTags buildBranchesAndTags(BranchesAndTags branchesAndTags, String line) {
        String remainder = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(line), (Function1 & Serializable)_$1 -> this.$anonfun$3(BoxesRunTime.unboxToChar((Object)_$1)))), "\t");
        if (remainder.startsWith("refs/heads/")) {
            String string = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(remainder), "refs/heads/");
            List list = branchesAndTags.branches().$colon$colon((Object)string);
            String string2 = branchesAndTags.copy$default$1();
            List list2 = branchesAndTags.copy$default$3();
            return branchesAndTags.copy(string2, list, list2);
        }
        if (remainder.startsWith("refs/tags/") && !remainder.endsWith("^{}")) {
            String string = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(remainder), "refs/tags/");
            List list = branchesAndTags.tags().$colon$colon((Object)string);
            String string3 = branchesAndTags.copy$default$1();
            List list3 = branchesAndTags.copy$default$2();
            return branchesAndTags.copy(string3, list3, list);
        }
        return branchesAndTags;
    }

    public Either<Object, File> clone(String repository, GitLogic.PullSource pullSource, PLogger proclog) {
        File tmpDir = Files.createTempDirectory("git-deploy", new FileAttribute[0]).toFile();
        this.log().info(() -> this.clone$$anonfun$1(repository, tmpDir), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.gitdeploy.GitLogic.clone"));
        int ret = Process$.MODULE$.apply("git -C " + tmpDir.getAbsolutePath() + " -c advice.detachedHead=false clone " + repository + " -q --single-branch --branch \"" + this.safe(pullSource.value()) + "\" ").$bang((ProcessLogger)IdLogger$.MODULE$.apply("clone", proclog));
        if (ret == 0) {
            return package$.MODULE$.Right().apply((Object)tmpDir);
        }
        tmpDir.delete();
        return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToInteger((int)ret));
    }

    public int push(Option<UserDB.User> optUser, GitLogic.Branch branch, Option<GitLogic.Tag> optTag, File dir, PLogger proclog) {
        String extra = (String)optUser.map((Function1 & Serializable)u -> " (by " + this.safe(u.name()) + ")").getOrElse(this::$anonfun$5);
        String userExtras = (String)optUser.map((Function1 & Serializable)user -> this.buildUserExtras((UserDB.User)user)).getOrElse(this::$anonfun$7);
        String msg = "Ambience git-deploy push" + extra;
        String quotedBase = "\"" + dir.getAbsolutePath() + "\"";
        String branchName = this.safe(branch.value());
        if (Process$.MODULE$.apply("git -C " + quotedBase + " add .").$bang((ProcessLogger)IdLogger$.MODULE$.apply("add", proclog)) == 0) {
            String commit = "git " + userExtras + " -C " + quotedBase + " commit -m \"" + msg + "\"";
            this.log().info(() -> this.push$$anonfun$1(commit), Line$.MODULE$.apply(66), FullName$.MODULE$.apply("ambience.gitdeploy.GitLogic.push"));
            if (Process$.MODULE$.apply(commit).$bang((ProcessLogger)IdLogger$.MODULE$.apply("commit", proclog)) == 0) {
                int ret = Process$.MODULE$.apply("git -C " + quotedBase + " push origin \"" + branchName + "\"").$bang((ProcessLogger)IdLogger$.MODULE$.apply("push", proclog));
                if (ret == 0) {
                    optTag.foreach((Function1 & Serializable)tag -> {
                        String tagName = this.safe(tag.value());
                        Process$.MODULE$.apply("git -C " + quotedBase + " push origin \":refs/tags/" + tagName + "\"").$bang((ProcessLogger)IdLogger$.MODULE$.apply("removeTag", proclog));
                        Process$.MODULE$.apply("git " + userExtras + " -C " + quotedBase + " tag -f \"" + tagName + "\"").$bang((ProcessLogger)IdLogger$.MODULE$.apply("setTag", proclog));
                        return Process$.MODULE$.apply("git -C " + quotedBase + " push origin \"" + branchName + "\" --tags").$bang((ProcessLogger)IdLogger$.MODULE$.apply("pushTag", proclog));
                    });
                }
                return ret;
            }
            return -4;
        }
        return -5;
    }

    public String buildUserExtras(UserDB.User user) {
        return "-c user.name=\"" + this.safe(user.name()) + "\" -c user.email=\"" + this.safe(user.email()) + "\" ";
    }

    public String safe(String s) {
        return s.replace("$", "\\$").replace("!", "\\!").replace("`", "\\`");
    }

    private final Object branchAndTagNames$$anonfun$1(String repository$4) {
        return "git ls-remote " + repository$4;
    }

    private final Object branchAndTagNames$$anonfun$2(List all$1) {
        return "bat: " + all$1.mkString("\n");
    }

    private final Object branchAndTagNames$$anonfun$3(String repository$5, Throwable ex$1) {
        return "Unable to read branches and tags for " + repository$5 + ": " + ex$1;
    }

    private final /* synthetic */ boolean $anonfun$3(char _$1) {
        return _$1 != '\t';
    }

    private final Object clone$$anonfun$1(String repository$6, File tmpDir$1) {
        return "Cloning " + repository$6 + " to " + tmpDir$1.getAbsolutePath();
    }

    private final String $anonfun$5() {
        return "";
    }

    private final String $anonfun$7() {
        return "";
    }

    private final Object push$$anonfun$1(String commit$1) {
        return commit$1;
    }
}

