/*
 * Decompiled with CFR 0.152.
 */
package ambience.gitdeploy;

import ambience.cli.CommandProcessor;
import ambience.gitdeploy.ConsoleProcLogger$;
import ambience.gitdeploy.GitDeployModule$;
import ambience.gitdeploy.GitLogic;
import ambience.gitdeploy.GitLogic$;
import ambience.gitdeploy.GitLogic$Branch$;
import ambience.gitdeploy.GitLogic$Tag$;
import ambience.gitdeploy.Init$;
import ambience.gitdeploy.PLogger;
import ambience.gitdeploy.Repositories;
import ambience.gitdeploy.Repositories$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import org.apache.commons.io.FileUtils;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GitPushCommandProcessor$
implements CommandProcessor,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitPushCommandProcessor$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final JsonWriterSettings JSW;
    public static final GitPushCommandProcessor$ MODULE$;

    private GitPushCommandProcessor$() {
    }

    static {
        MODULE$ = new GitPushCommandProcessor$();
        JSW = JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).indent(true).build();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitPushCommandProcessor$.class);
    }

    public JsonWriterSettings JSW() {
        return JSW;
    }

    public String name() {
        return "git-push";
    }

    public String help() {
        return "Saves the MongoDB contents into a git repository branch";
    }

    public String usage() {
        return "git-push <repository-name> <branch>";
    }

    public int main(Seq<String> params) {
        Init$.MODULE$.runOnce();
        List list = params.toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String repName = (String)colon2.head();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                List list3 = colon3.next$access$1();
                String branchName = (String)colon3.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    Option option = Repositories$.MODULE$.ChoiceMap().get((Object)repName);
                    if (option instanceof Some) {
                        Object object = ((Some)option).value();
                        String repository = object == null ? null : ((Repositories.Repository)object).value();
                        return this.push((Option<UserDB.User>)None$.MODULE$, repository, branchName, (Option<String>)None$.MODULE$, ConsoleProcLogger$.MODULE$);
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.log().warn(this::main$$anonfun$1, Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.main"));
                        this.log().info(this::main$$anonfun$2, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.main"));
                        return -1;
                    }
                    throw new MatchError((Object)option);
                }
            }
        }
        this.log().warn(this::main$$anonfun$3, Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.main"));
        this.log().info(this::main$$anonfun$4, Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.main"));
        return -1;
    }

    public int push(Option<UserDB.User> optUser, String repository, String branchName, Option<String> optTag, PLogger proclog) {
        Either<Object, File> either = GitLogic$.MODULE$.clone(repository, GitLogic$Branch$.MODULE$.apply(branchName), proclog);
        if (either instanceof Right) {
            int n;
            File tmpDir = (File)((Right)either).value();
            try {
                n = this.saveTo(optUser, branchName, optTag, tmpDir, proclog);
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (Exception ex) {
                    this.log().warn(() -> this.push$$anonfun$1(tmpDir, ex), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.push"));
                }
                throw throwable;
            }
            int n2 = n;
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (Exception ex) {
                this.log().warn(() -> this.push$$anonfun$1(tmpDir, ex), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.push"));
            }
            return n2;
        }
        if (either instanceof Left) {
            int errCode = BoxesRunTime.unboxToInt((Object)((Left)either).value());
            return errCode;
        }
        throw new MatchError(either);
    }

    public int saveTo(Option<UserDB.User> optUser, String branchName, Option<String> optTag, File tmpDir, PLogger proclog) {
        List children;
        List list = children = Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)tmpDir.listFiles()).getOrElse(this::$anonfun$1)).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            proclog.err((Function0<String>)((Function0 & Serializable)this::saveTo$$anonfun$1));
            this.log().error(this::saveTo$$anonfun$2, Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.saveTo"));
            return -2;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            File root = (File)colon2.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                this.log().info(() -> this.saveTo$$anonfun$3(root), Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.saveTo"));
                Await$.MODULE$.result((Awaitable)this.saveCollections(root, Repositories$.MODULE$.Collections(), proclog).runToFuture(Scheduler$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
                GitLogic$.MODULE$.push(optUser, GitLogic$Branch$.MODULE$.apply(branchName), (Option<GitLogic.Tag>)optTag.map((Function1 & Serializable)value -> GitLogic$Tag$.MODULE$.apply((String)value)), root, proclog);
                return 0;
            }
        }
        proclog.err((Function0<String>)((Function0 & Serializable)this::saveTo$$anonfun$5));
        this.log().error(this::saveTo$$anonfun$6, Line$.MODULE$.apply(88), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.saveTo"));
        return -3;
    }

    public Task<BoxedUnit> saveCollections(File file, List<String> cltns, PLogger proclog) {
        List<String> list = cltns;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list3;
            return this.saveCollection(file, head, proclog).flatMap((Function1 & Serializable)_$1 -> this.saveCollections(file, (List<String>)tail, proclog));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> saveCollection(File file, String cltnName, PLogger proclog) {
        File base = new File(file, cltnName);
        FileUtils.deleteDirectory((File)base);
        base.mkdirs();
        proclog.out((Function0<String>)((Function0 & Serializable)() -> this.saveCollection$$anonfun$1(cltnName)));
        this.log().info(() -> this.saveCollection$$anonfun$2(cltnName), Line$.MODULE$.apply(105), FullName$.MODULE$.apply("ambience.gitdeploy.GitPushCommandProcessor.saveCollection"));
        RichMongoCollection cltn = GitDeployModule$.MODULE$.getCollection(cltnName);
        return cltn.findO().map((Function1)(JProcedure1 & Serializable)doc -> this.saveRecord(base, (Document)doc)).toListL().map((Function1)(JProcedure1 & Serializable)_$2 -> {});
    }

    public void saveRecord(File base, Document doc) {
        String string;
        BsonValue bsonValue = doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId obj = (BsonObjectId)bsonValue;
            string = obj.getValue().toHexString() + ".json";
        } else if (bsonValue instanceof BsonString) {
            BsonString s = (BsonString)bsonValue;
            string = s.getValue() + ".json";
        } else {
            BsonValue x = bsonValue;
            string = String.valueOf(x) + ".json";
        }
        String filename = string;
        File file = new File(base, filename);
        byte[] bytes = doc.toJson(this.JSW()).getBytes(StandardCharsets.UTF_8);
        Files.write(file.toPath(), bytes, new OpenOption[0]);
    }

    private final Object main$$anonfun$1() {
        return "Unknown repository";
    }

    private final Object main$$anonfun$2() {
        return "Available repositories are: " + ((IterableOnceOps)Repositories$.MODULE$.ChoiceMap().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    private final Object main$$anonfun$3() {
        return "Expected <repository-name> <branch>";
    }

    private final Object main$$anonfun$4() {
        return "Available repositories are: " + ((IterableOnceOps)Repositories$.MODULE$.ChoiceMap().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    private final Object push$$anonfun$1(File tmpDir$1, Exception ex$1) {
        return "Can't delete " + tmpDir$1.getAbsolutePath() + ": " + ex$1;
    }

    private final File[] $anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private final String saveTo$$anonfun$1() {
        return "Missing repository folder";
    }

    private final Object saveTo$$anonfun$2() {
        return "Missing repository folder";
    }

    private final Object saveTo$$anonfun$3(File root$1) {
        return "Saving to " + root$1.getAbsolutePath();
    }

    private final String saveTo$$anonfun$5() {
        return "More than one folder choice available";
    }

    private final Object saveTo$$anonfun$6() {
        return "More than one folder choice available";
    }

    private final String saveCollection$$anonfun$1(String cltnName$1) {
        return "Copying collection " + cltnName$1;
    }

    private final Object saveCollection$$anonfun$2(String cltnName$2) {
        return "Copying collection " + cltnName$2;
    }
}

