/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages;

import ambience.framework.DocumentManager2$;
import ambience.framework.UUIDDocumentManager2;
import ambience.messages.DocumentManager$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Sorts$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class DocumentManager
extends UUIDDocumentManager2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DocumentManager.class.getDeclaredField("extension$lzy1"));
    private volatile Object extension$lzy1;

    public static Bson withId(BsonString bsonString) {
        return DocumentManager$.MODULE$.withId(bsonString);
    }

    public static Bson withId(String string) {
        return DocumentManager$.MODULE$.withId(string);
    }

    public DocumentManager() {
        DocumentManager2$.MODULE$.setupUniqueColumn(this.cltn(), this.uniqueKey());
    }

    public abstract ExecutionContext exeCxt();

    public abstract RichMongoCollection cltn();

    public abstract String uniqueKey();

    public String extension() {
        Object object = this.extension$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.extension$lzyINIT1();
    }

    private Object extension$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.extension$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = "messages.json";
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.extension$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Bson owner(UserDB.User user) {
        return Filters$.MODULE$.eq("owner", (Object)BsonString$.MODULE$.apply(user.id()));
    }

    public Task<Json> get(UserDB.User user) {
        Some some = Some$.MODULE$.apply((Object)Sorts$.MODULE$.descending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"created"})));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$3();
        Option option3 = FindOptions$.MODULE$.$lessinit$greater$default$4();
        FindOptions opts = FindOptions$.MODULE$.apply(option, (Option)some, option2, option3);
        return this.cltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{this.owner(user), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), opts).toListL().map((Function1 & Serializable)reply -> {
            Either either = io.circe.parser.package$.MODULE$.parse(reply.map((Function1 & Serializable)_$1 -> _$1.toJson()).mkString("[", ",", "]"));
            if (either instanceof Left) {
                ParsingFailure err = (ParsingFailure)((Left)either).value();
                ((LoggingMixin)this).log().error(() -> DocumentManager.get$$anonfun$1$$anonfun$2(err), Line$.MODULE$.apply(43), FullName$.MODULE$.apply("ambience.messages.DocumentManager.get"));
                return Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Json json = (Json)((Right)either).value();
                return json;
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg2 = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg2));
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonString id = (BsonString)((Some)option).value();
                return this.update(user, id, key, doc).map((Function1 & Serializable)msg -> package$.MODULE$.Left().apply(msg));
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(user, key, doc).map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> this.docToJson((Document)doc)));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Json docToJson(Document doc) {
        Either either = io.circe.parser.package$.MODULE$.parse(doc.toJson());
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            throw new IllegalStateException("Unable to parse Bson as Json: " + err);
        }
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return json;
        }
        throw new MatchError((Object)either);
    }

    public Task<LogMessage> delete(UserDB.User user, String uuid) {
        ((LoggingMixin)this).log().info(() -> DocumentManager.delete$$anonfun$1(uuid), Line$.MODULE$.apply(74), FullName$.MODULE$.apply("ambience.messages.DocumentManager.delete"));
        return this.cltn().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager$.MODULE$.withId(uuid), this.owner(user)})), DocumentManager2$.MODULE$.deleteAction(this.uniqueKey())).map((Function1 & Serializable)_$2 -> LogMessage.None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Delete failed", ex);
            }
        });
    }

    public Task<LogMessage> undelete(UserDB.User user, String uuid) {
        ((LoggingMixin)this).log().info(() -> DocumentManager.undelete$$anonfun$1(uuid), Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.messages.DocumentManager.undelete"));
        return this.cltn().updateOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager$.MODULE$.withId(uuid), this.owner(user)})), DocumentManager2$.MODULE$.undeleteAction(this.uniqueKey())).map((Function1 & Serializable)_$3 -> LogMessage.None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Undelete failed", ex);
            }
        });
    }

    public Task<Either<LogMessage, Document>> add(UserDB.User user, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocumentManager.add$$anonfun$1(key), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.messages.DocumentManager.add"));
        BsonString id = BsonString$.MODULE$.apply(UUID.randomUUID().toString());
        BsonString owner = BsonString$.MODULE$.apply(user.id());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)owner), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document finalDoc = (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return this.cltn().insertOneT(finalDoc).map((Function1 & Serializable)_$4 -> package$.MODULE$.Right().apply((Object)finalDoc)).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Add failed", ex));
            }
        });
    }

    public Task<LogMessage> update(UserDB.User user, BsonString id, BsonValue key, Document doc) {
        ((LoggingMixin)this).log().info(() -> DocumentManager.update$$anonfun$1(key), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.messages.DocumentManager.update"));
        return this.cltn().replaceOneT(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{DocumentManager$.MODULE$.withId(id), this.owner(user), DocumentManager2$.MODULE$.exists(this.uniqueKey())})), doc).map((Function1 & Serializable)_$5 -> LogMessage.None$.MODULE$).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return LogMessage.ErrorEx$.MODULE$.apply("Update failed", ex);
            }
        });
    }

    public Either<LogMessage, Option<BsonString>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)s));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(this.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    private static final Object get$$anonfun$1$$anonfun$2(ParsingFailure err$1) {
        return "Error parsing BSON json output: " + err$1;
    }

    private static final Object delete$$anonfun$1(String uuid$1) {
        return "deleting " + uuid$1;
    }

    private static final Object undelete$$anonfun$1(String uuid$2) {
        return "undeleting " + uuid$2;
    }

    private static final Object add$$anonfun$1(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private static final Object update$$anonfun$1(BsonValue key$2) {
        return "updating " + key$2;
    }
}

