/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages;

import ambience.gravity.GravityHelper$;
import ambience.messages.DocRoute;
import ambience.messages.InboxDocumentRoute;
import ambience.messages.MessagesDocumentManager;
import ambience.messages.MessagesModule;
import ambience.messages.Util$;
import ambience.messages.db.UserDBHelper$;
import ambience.messages.store.AttachmentsStore$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonString$;
import scala.Function1;
import scala.MatchError;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MessagesDocumentRoute
extends DocRoute {
    private final MessagesDocumentManager mgr;
    private final String writeGroup;

    public MessagesDocumentRoute(MessagesModule module, MessagesDocumentManager mgr, String writeGroup) {
        this.mgr = mgr;
        this.writeGroup = writeGroup;
        super(module.mongoDB(), mgr, writeGroup);
    }

    public List<GravityRoute> routes(UserDB.User user) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GravityRoute[]{GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data", (Function1 & Serializable)request -> this.getData(user, (GravityRequest)request)), GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "data", (Function1 & Serializable)request -> this.canWrite(user, (Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postData((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.GET(), "data-download", (Function1 & Serializable)request -> this.getDataDownload(user, (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-delete", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataDelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-undelete", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataUndelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-delete-all", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.deleteAll((UserDB.User)user), (GravityRequest)request))}));
    }

    public Task<GravityResponse> all(UserDB.User user) {
        return UserDBHelper$.MODULE$.userInfoMapT().flatMap((Function1 & Serializable)userInfo -> this.mgr.get(user).flatMap((Function1 & Serializable)json -> {
            List tasks = ((List)json.asArray().map((Function1 & Serializable)_$1 -> _$1.toList()).getOrElse(MessagesDocumentRoute::$anonfun$2)).map((Function1 & Serializable)mJson -> {
                Seq<Json> to = this.idToUserName((Map<String, InboxDocumentRoute.UserInfo>)userInfo, (Seq<Json>)((Seq)Util$.MODULE$.TO().getOption(mJson).getOrElse(MessagesDocumentRoute::$anonfun$4)), (Json)mJson);
                String toNames = ((IterableOnceOps)to.flatMap((Function1 & Serializable)_$2 -> _$2.asString())).mkString(",");
                List attachmentIds = ((List)Util$.MODULE$.Attachments().getOption(mJson).map((Function1 & Serializable)_$3 -> _$3.toList()).getOrElse(MessagesDocumentRoute::$anonfun$7)).flatMap((Function1 & Serializable)_$4 -> _$4.asString());
                Task attachmentsTask = attachmentIds.isEmpty() ? Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil()))) : this.loadAttachments((Json)mJson, (List<String>)attachmentIds);
                return attachmentsTask.map((Function1 & Serializable)x$1 -> {
                    LogMessage logMessage;
                    Either either = x$1;
                    if (either instanceof Left && (logMessage = (LogMessage)((Left)either).value()) != null) {
                        LogMessage err = logMessage;
                        this.log().error(() -> MessagesDocumentRoute.$anonfun$3$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.messages.MessagesDocumentRoute.tasks"));
                        return mJson.mapObject((Function1 & Serializable)_$5 -> _$5.add("toNames", Json$.MODULE$.fromString(toNames)));
                    }
                    if (either instanceof Right) {
                        Json attachJsonList = (Json)((Right)either).value();
                        return mJson.mapObject((Function1 & Serializable)_$6 -> _$6.add("toNames", Json$.MODULE$.fromString(toNames)).add("attachments", attachJsonList));
                    }
                    throw new MatchError((Object)either);
                });
            });
            return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)vs -> GravityResponse$.MODULE$.json(Json$.MODULE$.fromValues((Iterable)vs)));
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> deleteAll(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$7 -> {
            Vector ids = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)json.asArray().getOrElse(MessagesDocumentRoute::$anonfun$9)).flatMap((Function1 & Serializable)_$8 -> _$8.asString())).map((Function1 & Serializable)_$9 -> BsonString$.MODULE$.apply(_$9));
            return this.mgr.deleteAll(user, (Set<BsonString>)ids.toSet()).map((Function1 & Serializable)msg -> GravityHelper$.MODULE$.toResponse(msg));
        });
    }

    public Task<Either<LogMessage, Json>> loadAttachments(Json json, List<String> uuids) {
        return AttachmentsStore$.MODULE$.load(AttachmentsStore$.MODULE$.getStoreInfo(json), uuids);
    }

    public Task<GravityResponse> canDelete(UserDB.User user, Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn, GravityRequest request) {
        if (user.privileges().contains((Object)this.writeGroup) && user.privileges().contains((Object)"mod-messages-delete")) {
            return (Task)((Function1)fn.apply((Object)user)).apply((Object)request);
        }
        return Gravity$.MODULE$.ForbiddenResponseT();
    }

    private static final List $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final AbstractSeq $anonfun$4() {
        return package$.MODULE$.Nil();
    }

    private static final List $anonfun$7() {
        return package$.MODULE$.Nil();
    }

    private static final Object $anonfun$3$$anonfun$1$$anonfun$1(LogMessage err$1) {
        return err$1.msg();
    }

    private static final Vector $anonfun$9() {
        return package$.MODULE$.Vector().empty();
    }
}

