/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages.store;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.arch.EitherTELM$;
import ambience.format.HumanReadableBytes$;
import ambience.messages.Util$;
import cats.Alternative;
import cats.Bifoldable;
import cats.FlatMap;
import cats.implicits$;
import cats.syntax.SeparateOps;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonBinary;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AttachmentsBinStore
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AttachmentsBinStore.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String sendLocationId;

    public AttachmentsBinStore(String sendLocationId) {
        this.sendLocationId = sendLocationId;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<LogMessage, List<String>>> send(List<Document> docs) {
        return ((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(this.sendLocationId).map((Function1 & Serializable)_$1 -> _$1.toRight(this::send$$anonfun$1$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage.Error lm = (LogMessage.Error)((Left)either).value();
                return Task$.MODULE$.apply(() -> AttachmentsBinStore.send$$anonfun$2$$anonfun$1(lm));
            }
            if (either instanceof Right) {
                BinaryStore.Location location = (BinaryStore.Location)((Right)either).value();
                return this.handleReply(location, (List<Task<Either<LogMessage, String>>>)docs.map((Function1 & Serializable)_$2 -> this.send(location, (Document)_$2)));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, String>> send(BinaryStore.Location location, Document doc) {
        Json metadata = this.toMetadata(doc);
        Task task = EitherTELM$.MODULE$.apply(this.debugT("Storing Attachment store=" + location.id() + " metadata=" + metadata).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(Task$.MODULE$.apply(() -> AttachmentsBinStore.$anonfun$2$$anonfun$1(doc))).flatMap((Function1 & Serializable)bytes -> EitherTELM$.MODULE$.apply(this.doWrite(location, metadata, DataBytes$.MODULE$.apply(bytes.getData()))).flatMap((Function1 & Serializable)uuid -> EitherTELM$.MODULE$.apply(this.infoT("New Attachment Added store=" + location.id() + " uuid=" + uuid).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return uuid;
            })));
        }).value();
        return task.onErrorRecover((PartialFunction)new Serializable(metadata){
            private final Json metadata$3;
            {
                this.metadata$3 = metadata$4;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return true;
                }
                Throwable ex = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    String name = (String)Util$.MODULE$.Name().getOption((Object)this.metadata$3).getOrElse(AttachmentsBinStore::ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$3);
                    long len = BoxesRunTime.unboxToLong((Object)Util$.MODULE$.Length().getOption((Object)this.metadata$3).getOrElse(AttachmentsBinStore::ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$4));
                    return scala.package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(len + ":" + name, (Throwable)ex));
                }
                Throwable ex = throwable;
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("ss" + ex, ex));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$3(), ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$4()}, serializedLambda);
            }
        });
    }

    public Task<Either<LogMessage, List<String>>> handleReply(BinaryStore.Location location, List<Task<Either<LogMessage, String>>> tasks) {
        return Task$.MODULE$.sequence(tasks, BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)eithers -> {
            Tuple2 tuple2 = new SeparateOps(implicits$.MODULE$.catsSyntaxAlternativeSeparate(eithers)).separate((FlatMap)implicits$.MODULE$.catsStdInstancesForList(), (Alternative)implicits$.MODULE$.catsStdInstancesForList(), (Bifoldable)implicits$.MODULE$.catsStdBitraverseForEither());
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                List list2 = (List)tuple2._2();
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list3 = list;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    List ids = list2;
                    return Task$.MODULE$.apply(() -> AttachmentsBinStore.handleReply$$anonfun$1$$anonfun$1(ids));
                }
                List errs = list;
                List ids = list2;
                Tuple2 tuple22 = errs.partition((Function1 & Serializable)x$1 -> {
                    LogMessage logMessage = x$1;
                    if (logMessage instanceof LogMessage.ErrorEx) {
                        LogMessage.ErrorEx errorEx = LogMessage.ErrorEx$.MODULE$.unapply((LogMessage.ErrorEx)logMessage);
                        String string = errorEx._1();
                        Throwable throwable = errorEx._2();
                        if (throwable instanceof BinaryStore.MaxSizeException) {
                            return true;
                        }
                    }
                    return false;
                });
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                List msLm = (List)tuple22._1();
                List lm = (List)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)msLm, (Object)lm);
                List msLm2 = (List)tuple23._1();
                List lm2 = (List)tuple23._2();
                return this.delete(location, (List<String>)ids).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    LogMessage logMessage = x$1;
                    if (LogMessage.None$.MODULE$.equals(logMessage)) {
                        return;
                    }
                    LogMessage lm = logMessage;
                    this.log().error(() -> AttachmentsBinStore.handleReply$$anonfun$1$$anonfun$2$$anonfun$1(lm), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.messages.store.AttachmentsBinStore.handleReply"));
                }).map((Function1 & Serializable)_$3 -> scala.package$.MODULE$.Left().apply((Object)this.buildErrorReply(location, (List<LogMessage>)msLm2, (List<LogMessage>)lm2)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public LogMessage buildErrorReply(BinaryStore.Location location, List<LogMessage> maxSizeLms, List<LogMessage> otherLms) {
        String header = "<p>Message Send Failed</p><p>Binary Store Attachment upload limit " + this.humanReadableBytesSpan(location.maxSize()) + " exceeded.</p>";
        List l = (List)((IterableOps)((IterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{header}))).$plus$plus((IterableOnce)maxSizeLms.map((Function1 & Serializable)_$4 -> this.buildFileMaxsizeError((LogMessage)_$4)))).$plus$plus((IterableOnce)otherLms.map((Function1 & Serializable)lm -> "<p>" + lm.msg() + "</p>"));
        return LogMessage.Error$.MODULE$.apply(l.mkString("<p>", "", "</p>"));
    }

    /*
     * Unable to fully structure code
     */
    public String buildFileMaxsizeError(LogMessage lm) {
        var3_2 = Predef$.MODULE$.wrapRefArray((Object[])lm.msg().split(":")).toList();
        if (!(var3_2 instanceof .colon.colon)) ** GOTO lbl-1000
        var4_3 = (.colon.colon)var3_2;
        var5_4 = var4_3.next$access$1();
        size = (String)var4_3.head();
        if (!(var5_4 instanceof .colon.colon)) ** GOTO lbl-1000
        var7_6 = (.colon.colon)var5_4;
        var8_7 = var7_6.next$access$1();
        name = (String)var7_6.head();
        v0 = scala.package$.MODULE$.Nil();
        var10_9 = var8_7;
        if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
            v1 = Tuple2$.MODULE$.apply(StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(size)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(), ()J)()), (Object)name);
        } else lbl-1000:
        // 3 sources

        {
            v1 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)"ERROR");
        }
        var2_10 = v1;
        size = BoxesRunTime.unboxToLong((Object)var2_10._1());
        name = (String)var2_10._2();
        return "<p>" + name + " Actual (" + this.humanReadableBytesSpan(size) + ").</p>";
    }

    public Task<Either<LogMessage, Document>> load(String locationId, String id) {
        return BinaryStore$.MODULE$.get(BinaryStore.Id$.MODULE$.apply(locationId, BinaryStore.ContentId$.MODULE$.apply(id))).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                return this.toDocument(content).map((Function1 & Serializable)_$5 -> scala.package$.MODULE$.Right().apply(_$5));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> AttachmentsBinStore.load$$anonfun$1$$anonfun$2(locationId, id), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.messages.store.AttachmentsBinStore.load"));
                return Task$.MODULE$.left((Object)LogMessage.Error$.MODULE$.apply("No content found in binary store=" + locationId + " for contentId " + id));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, Json>> loadMetadata(String locationId, String id) {
        return BinaryStore$.MODULE$.get(BinaryStore.Id$.MODULE$.apply(locationId, BinaryStore.ContentId$.MODULE$.apply(id))).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(id));
                return scala.package$.MODULE$.Right().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).deepMerge(content.metadata()));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().warn(() -> AttachmentsBinStore.loadMetadata$$anonfun$1$$anonfun$1(locationId, id), Line$.MODULE$.apply(94), FullName$.MODULE$.apply("ambience.messages.store.AttachmentsBinStore.loadMetadata"));
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("No content found in binary store=" + locationId + " for contentId " + id));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, Json>> load(String locationId, List<String> ids) {
        List tasks = ids.map((Function1 & Serializable)_$6 -> this.loadMetadata(locationId, (String)_$6));
        return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)eithers -> {
            Tuple2 tuple2 = new SeparateOps(implicits$.MODULE$.catsSyntaxAlternativeSeparate(eithers)).separate((FlatMap)implicits$.MODULE$.catsStdInstancesForList(), (Alternative)implicits$.MODULE$.catsStdInstancesForList(), (Bifoldable)implicits$.MODULE$.catsStdBitraverseForEither());
            if (tuple2 != null) {
                List list = (List)tuple2._1();
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    List list3 = (List)tuple2._2();
                    Either either = package$.MODULE$.parse(list3.map((Function1 & Serializable)_$7 -> _$7.noSpaces()).mkString("[", ",", "]"));
                    if (either instanceof Left) {
                        ParsingFailure err = (ParsingFailure)((Left)either).value();
                        return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply(err.getMessage()));
                    }
                    if (either instanceof Right) {
                        Json json = (Json)((Right)either).value();
                        return scala.package$.MODULE$.Right().apply((Object)json);
                    }
                    throw new MatchError((Object)either);
                }
                List errs = list;
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(errs));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Task<LogMessage> delete(String locationId, List<String> ids) {
        return ((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(locationId).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location loc = (BinaryStore.Location)((Some)option).value();
                return this.delete(loc, ids);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)LogMessage.Error$.MODULE$.apply("Binary Store location " + locationId + " not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<LogMessage> delete(BinaryStore.Location location, List<String> ids) {
        List tasks = ids.map((Function1 & Serializable)id -> location.remove(BinaryStore.ContentId$.MODULE$.apply(id)).as((Object)LogMessage.None$.MODULE$));
        return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)logs -> LogMessage.LogMessageList$.MODULE$.apply(logs));
    }

    private Task<Either<LogMessage, String>> doWrite(BinaryStore.Location location, Json metadata, DataBytes dataBytes) {
        return location.add(BinaryStore.Content$.MODULE$.apply(dataBytes, metadata)).map((Function1 & Serializable)_$8 -> _$8 == null ? null : ((BinaryStore.ContentId)_$8).value()).map((Function1 & Serializable)value -> scala.package$.MODULE$.Right().apply(value));
    }

    private Json toMetadata(Document doc) {
        return (Json)doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)n -> doc.get("length", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)l -> {
            String ct = (String)doc.get("contentType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).getOrElse(AttachmentsBinStore::$anonfun$12);
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(n.getValue()));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromLong(Int$.MODULE$.int2long(l.getValue())));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentType");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(ct));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        })).getOrElse(AttachmentsBinStore::toMetadata$$anonfun$2);
    }

    private Task<Document> toDocument(BinaryStore.Content content) {
        Json md = content.metadata();
        BsonString name = BsonString$.MODULE$.apply((String)md.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(AttachmentsBinStore::$anonfun$13));
        BsonInt64 len = BsonInt64$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)md.hcursor().downField("length").as(Decoder$.MODULE$.decodeLong()).toOption().getOrElse(AttachmentsBinStore::$anonfun$14)));
        BsonString ct = BsonString$.MODULE$.apply((String)md.hcursor().downField("contentType").as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(AttachmentsBinStore::$anonfun$15));
        return content.bytes().observable().foldLeftL(AttachmentsBinStore::toDocument$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                byte[] a1 = (byte[])tuple2._1();
                byte[] a2 = (byte[])tuple2._2();
                return (byte[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{a1, a2}), ClassTag$.MODULE$.apply(Byte.TYPE));
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)bytes -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)name), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)len), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentType");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)ct), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
            objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        });
    }

    private Task<BoxedUnit> infoT(String msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.infoT$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    private Task<BoxedUnit> debugT(String msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.debugT$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public String exceedLimitError(long limit, String name, long size) {
        String safeName = this.safeString(name);
        return "<p>Attachment " + safeName + " size " + this.humanReadableBytesSpan(size) + " exceeds limit " + limit + "}</p>";
    }

    public String humanReadableBytesSpan(long bytes) {
        String tip = HumanReadableBytes$.MODULE$.tip(bytes);
        return "<span class=\"hr-bytes\" title=\"" + tip + "\">" + HumanReadableBytes$.MODULE$.apply(bytes) + "</span>";
    }

    public String safeString(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;");
    }

    private final LogMessage.Error send$$anonfun$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("BinaryStore location not found " + this.sendLocationId);
    }

    private static final Left send$$anonfun$2$$anonfun$1(LogMessage.Error lm$1) {
        return scala.package$.MODULE$.Left().apply((Object)lm$1);
    }

    private static final LogMessage.Error $anonfun$2$$anonfun$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("bytes field not found");
    }

    private static final Either $anonfun$2$$anonfun$1(Document doc$2) {
        return doc$2.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).toRight(AttachmentsBinStore::$anonfun$2$$anonfun$1$$anonfun$1);
    }

    public static final String ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$3() {
        return "";
    }

    public static final long ambience$messages$store$AttachmentsBinStore$$anon$1$$_$_$$anonfun$4() {
        return 0L;
    }

    private static final Right handleReply$$anonfun$1$$anonfun$1(List ids$1) {
        return scala.package$.MODULE$.Right().apply((Object)ids$1);
    }

    private static final Object handleReply$$anonfun$1$$anonfun$2$$anonfun$1(LogMessage lm$2) {
        return lm$2.msg();
    }

    private static final long $anonfun$8() {
        return 0L;
    }

    private static final Object load$$anonfun$1$$anonfun$2(String locationId$2, String id$2) {
        return "No content found in binary store=" + locationId$2 + " for contentId " + id$2;
    }

    private static final Object loadMetadata$$anonfun$1$$anonfun$1(String locationId$4, String id$4) {
        return "No content found in binary store=" + locationId$4 + " for contentId " + id$4;
    }

    private static final String $anonfun$12() {
        return "application/octet-stream";
    }

    private static final Json toMetadata$$anonfun$2() {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private static final String $anonfun$13() {
        return "";
    }

    private static final long $anonfun$14() {
        return 0L;
    }

    private static final String $anonfun$15() {
        return "";
    }

    private static final byte[] toDocument$$anonfun$1() {
        return Array$.MODULE$.emptyByteArray();
    }

    private static final Object infoT$$anonfun$1$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private final void infoT$$anonfun$1(String msg$1) {
        this.log().info(() -> AttachmentsBinStore.infoT$$anonfun$1$$anonfun$1(msg$1), Line$.MODULE$.apply(157), FullName$.MODULE$.apply("ambience.messages.store.AttachmentsBinStore.infoT"));
    }

    private static final Object debugT$$anonfun$1$$anonfun$1(String msg$4) {
        return msg$4;
    }

    private final void debugT$$anonfun$1(String msg$3) {
        this.log().debug(() -> AttachmentsBinStore.debugT$$anonfun$1$$anonfun$1(msg$3), Line$.MODULE$.apply(159), FullName$.MODULE$.apply("ambience.messages.store.AttachmentsBinStore.debugT"));
    }
}

