/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.binary;

import ambience.bson.BsonETL$;
import ambience.etl.ETLStep;
import ambience.etl.binary.CipherLogic;
import ambience.etl.binary.CipherLogic$IV$;
import ambience.etl.binary.CipherLogic$Info$;
import ambience.etl.binary.CipherLogic$Params$;
import ambience.etl.binary.CipherLogic$Secret$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import monix.eval.Task;
import monix.eval.Task$;
import org.apache.commons.codec.binary.Base64;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple5$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;

public final class CipherLogic$
implements Serializable {
    private static final String Default;
    private static final List AlgorithmChoices;
    public static final CipherLogic$Info$ Info;
    private static final Json InfoJson;
    public static final CipherLogic$Secret$ Secret;
    public static final CipherLogic$IV$ IV;
    public static final CipherLogic$Params$ Params;
    public static final CipherLogic$ MODULE$;

    private CipherLogic$() {
    }

    static {
        MODULE$ = new CipherLogic$();
        Default = "AES/CBC/PKCS5Padding";
        AlgorithmChoices = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.SelectChoice[]{Panel.SelectChoice$.MODULE$.apply(MODULE$.Default(), Json$.MODULE$.fromString(MODULE$.Default()))}));
        CipherLogic.Info info = (CipherLogic.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)CipherLogic$Info$.MODULE$.apply(CipherLogic$Info$.MODULE$.$lessinit$greater$default$1(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$2(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$3(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$4(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CipherLogic$.class);
    }

    public String Default() {
        return Default;
    }

    public List<Panel.SelectChoice> AlgorithmChoices() {
        return AlgorithmChoices;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public byte[] encrypt(String algorithm, CipherLogic.Params params, byte[] data) {
        Cipher cipher = Cipher.getInstance(algorithm);
        SecretKeySpec secretKeySpec = new SecretKeySpec(params.secret().value(), this.keyAlgorithm(algorithm));
        IvParameterSpec ivParamSpec = new IvParameterSpec(params.iv().value());
        cipher.init(1, (Key)secretKeySpec, ivParamSpec);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(String algorithm, CipherLogic.Params params, byte[] data) {
        Cipher cipher = Cipher.getInstance(algorithm);
        SecretKeySpec secretKeySpec = new SecretKeySpec(params.secret().value(), this.keyAlgorithm(algorithm));
        IvParameterSpec ivParamSpec = new IvParameterSpec(params.iv().value());
        cipher.init(2, (Key)secretKeySpec, ivParamSpec);
        return cipher.doFinal(data);
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        int size = 5;
        CipherLogic.Info info = (CipherLogic.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$anonfun$3))))).toOption().getOrElse(this::$anonfun$4);
        Panel.Item field = PanelItem$.MODULE$.text("field", "Bytes Field", info.field(), PanelItem$.MODULE$.text$default$4());
        Panel.Item secretField = PanelItem$.MODULE$.text("secretField", "Secret Field", info.secretField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item algorithm = PanelItem$.MODULE$.select("algorithm", "Algorithm", Json$.MODULE$.fromString(info.algorithm()), this.AlgorithmChoices(), PanelItem$.MODULE$.select$default$5());
        Panel.Item ivField = PanelItem$.MODULE$.text("ivField", "IV Field", info.ivField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item result = PanelItem$.MODULE$.text("result", "Result Field", info.result(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> this.buildPanel$$anonfun$1(field, secretField, algorithm, ivField, result));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> this.savePanel$$anonfun$1(results, step));
    }

    public Either<String, CipherLogic.Params> getParams(Document doc, CipherLogic.Info info) {
        return this.getSecretField(doc, info).flatMap((Function1 & Serializable)secret -> this.getIVField(doc, info).map((Function1 & Serializable)iv -> CipherLogic$Params$.MODULE$.apply((CipherLogic.Secret)secret, (CipherLogic.IV)iv)));
    }

    public Either<String, CipherLogic.Secret> getSecretField(Document doc, CipherLogic.Info info) {
        Option option = BsonETL$.MODULE$.get(doc, info.secretField());
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString secret = (BsonString)bsonValue;
                Either either = implicits$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this.getSecretField$$anonfun$1(secret)).toEither());
                return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)_$1 -> "Invalid Base64", (Function1 & Serializable)value -> CipherLogic$Secret$.MODULE$.apply((byte[])value));
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary secret = (BsonBinary)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$Secret$.MODULE$.apply(secret.getData()));
            }
            return package$.MODULE$.Left().apply((Object)("Secret field " + info.secretField() + " is not a string or bytes"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("Secret field " + info.secretField() + " does not exist"));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, CipherLogic.IV> getIVField(Document doc, CipherLogic.Info info) {
        Option option = BsonETL$.MODULE$.get(doc, info.ivField());
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString iv = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$IV$.MODULE$.apply(iv.getValue().getBytes("UTF-8")));
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary iv = (BsonBinary)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$IV$.MODULE$.apply(iv.getData()));
            }
            return package$.MODULE$.Left().apply((Object)("IV field " + info.ivField() + " is not a string or bytes"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("IV field " + info.ivField() + " does not exist"));
        }
        throw new MatchError((Object)option);
    }

    public String keyAlgorithm(String algorithm) {
        return "AES";
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var2_1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var2_1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $anonfun$2() {
        CipherLogic$Info$ cipherLogic$Info$ = CipherLogic$Info$.MODULE$;
        return (Function1 & Serializable)p -> (CipherLogic.Info)cipherLogic$Info$.fromProduct((Product)p);
    }

    private final Product $anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
    }

    private final CipherLogic.Info $anonfun$4() {
        return CipherLogic$Info$.MODULE$.apply(CipherLogic$Info$.MODULE$.$lessinit$greater$default$1(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$2(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$3(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$4(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$5());
    }

    private final Panel buildPanel$$anonfun$1(Panel.Item field$1, Panel.Item secretField$1, Panel.Item algorithm$1, Panel.Item ivField$1, Panel.Item result$1) {
        return Panel$.MODULE$.apply((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{field$1, secretField$1, algorithm$1, ivField$1, result$1})));
    }

    /*
     * WARNING - void declaration
     */
    private final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var2_1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 savePanel$$anonfun$1$$anonfun$2() {
        CipherLogic$Info$ cipherLogic$Info$ = CipherLogic$Info$.MODULE$;
        return (Function1 & Serializable)p -> (CipherLogic.Info)cipherLogic$Info$.fromProduct((Product)p);
    }

    private final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    private final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var2_1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    private final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(results$1).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", this::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            CipherLogic.Info info2 = (CipherLogic.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "field";
            String string2 = "secretField";
            String string3 = "algorithm";
            String string4 = "ivField";
            String string5 = "result";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(this::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string6 = step$1.copy$default$1();
            String string7 = step$1.copy$default$2();
            String string8 = step$1.copy$default$3();
            String string9 = step$1.copy$default$4();
            String string10 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string6, string7, string8, string9, string10, json, bl, bl2);
        });
    }

    private final byte[] getSecretField$$anonfun$1(BsonString secret$2) {
        return Base64.decodeBase64((String)secret$2.getValue());
    }
}

